/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.dataflow.core.dsl.DSLMessage;
import org.springframework.cloud.dataflow.core.dsl.ParseException;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.core.dsl.Tokens;
import org.springframework.util.Assert;

public abstract class AbstractTokenizer {
    private static final byte[] flags = new byte[256];
    private static final byte IS_DIGIT = 1;
    private static final byte IS_HEXDIGIT = 2;
    private static final byte IS_ALPHA = 4;
    private final int[] NO_LINEBREAKS = new int[0];
    protected String expressionString;
    protected char[] toProcess;
    protected int max;
    protected int pos;
    protected List<Token> tokens = new ArrayList<Token>();
    protected int[] linebreaks = this.NO_LINEBREAKS;

    abstract void process();

    public Tokens getTokens(String inputData) {
        this.expressionString = inputData;
        this.toProcess = (inputData + "\u0000").toCharArray();
        this.max = this.toProcess.length;
        this.pos = 0;
        this.tokens.clear();
        this.process();
        return new Tokens(inputData, this.tokens, this.linebreaks);
    }

    protected boolean isTwoCharToken(TokenKind kind) {
        Assert.isTrue((kind.tokenChars.length == 2 ? 1 : 0) != 0, (String)"The token kind being looked for should be of length 2");
        Assert.isTrue((this.toProcess[this.pos] == kind.tokenChars[0] ? 1 : 0) != 0, (String)"Expected these characters to have already been tested for equality");
        return this.toProcess[this.pos + 1] == kind.tokenChars[1];
    }

    protected void pushCharToken(TokenKind kind) {
        this.tokens.add(new Token(kind, this.pos, this.pos + 1));
        ++this.pos;
    }

    protected void pushPairToken(TokenKind kind) {
        this.tokens.add(new Token(kind, this.pos, this.pos + 2));
        this.pos += 2;
    }

    protected boolean isIdentifier(char ch) {
        return this.isAlphabetic(ch) || this.isDigit(ch) || ch == '_' || ch == '$' || ch == '-';
    }

    protected boolean isQuote(char ch) {
        return ch == '\'' || ch == '\"';
    }

    protected boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    protected boolean isDigit(char ch) {
        if (ch > '\u00ff') {
            return false;
        }
        return (flags[ch] & 1) != 0;
    }

    protected boolean isAlphabetic(char ch) {
        if (ch > '\u00ff') {
            return false;
        }
        return (flags[ch] & 4) != 0;
    }

    protected char[] subArray(int start, int end) {
        char[] result = new char[end - start];
        System.arraycopy(this.toProcess, start, result, 0, end - start);
        return result;
    }

    protected void lexIdentifier() {
        int start = this.pos;
        do {
            ++this.pos;
        } while (this.isIdentifier(this.toProcess[this.pos]));
        char[] subarray = this.subArray(start, this.pos);
        this.tokens.add(new Token(TokenKind.IDENTIFIER, subarray, start, this.pos));
    }

    protected void lexQuotedStringLiteral() {
        this.lexStringLiteral('\'', DSLMessage.NON_TERMINATING_QUOTED_STRING);
    }

    protected void lexDoubleQuotedStringLiteral() {
        this.lexStringLiteral('\"', DSLMessage.NON_TERMINATING_DOUBLE_QUOTED_STRING);
    }

    private void lexStringLiteral(char quoteChar, DSLMessage messageOnNonTerminationError) {
        int start = this.pos;
        boolean terminated = false;
        while (!terminated) {
            ++this.pos;
            char ch = this.toProcess[this.pos];
            if (ch == quoteChar) {
                if (this.toProcess[this.pos + 1] == quoteChar) {
                    ++this.pos;
                } else {
                    terminated = true;
                }
            }
            if (ch != '\u0000') continue;
            throw new ParseException(this.expressionString, start, messageOnNonTerminationError, new Object[0]);
        }
        ++this.pos;
        this.tokens.add(new Token(TokenKind.LITERAL_STRING, this.subArray(start, this.pos), start, this.pos));
    }

    protected boolean isArgValueIdentifierTerminator(char ch, boolean quoteOpen) {
        return ch == '|' && !quoteOpen || ch == ';' && !quoteOpen || ch == '\u0000' || ch == ' ' && !quoteOpen || ch == '\t' && !quoteOpen || ch == '>' && !quoteOpen || ch == '\r' && !quoteOpen || ch == '\n' && !quoteOpen;
    }

    protected void lexArgValueIdentifier() {
        int start = this.pos;
        boolean quoteOpen = false;
        int quoteClosedCount = 0;
        Character quoteInUse = null;
        if (this.isQuote(this.toProcess[this.pos])) {
            quoteOpen = true;
            quoteInUse = Character.valueOf(this.toProcess[this.pos++]);
        }
        do {
            char ch = this.toProcess[this.pos];
            if (quoteInUse != null && ch == quoteInUse.charValue() || quoteInUse == null && this.isQuote(ch)) {
                if (quoteInUse != null && quoteInUse.charValue() == '\'' && ch == '\'' && this.toProcess[this.pos + 1] == '\'') {
                    ++this.pos;
                } else {
                    boolean bl = quoteOpen = !quoteOpen;
                    if (!quoteOpen) {
                        ++quoteClosedCount;
                    }
                }
            }
            ++this.pos;
        } while (!this.isArgValueIdentifierTerminator(this.toProcess[this.pos], quoteOpen));
        char[] subarray = null;
        if (quoteInUse != null && quoteInUse.charValue() == '\"' && quoteClosedCount == 0) {
            throw new ParseException(this.expressionString, start, DSLMessage.NON_TERMINATING_DOUBLE_QUOTED_STRING, new Object[0]);
        }
        if (quoteInUse != null && quoteInUse.charValue() == '\'' && quoteClosedCount == 0) {
            throw new ParseException(this.expressionString, start, DSLMessage.NON_TERMINATING_QUOTED_STRING, new Object[0]);
        }
        if (quoteClosedCount == 1 && this.sameQuotes(start, this.pos - 1)) {
            this.tokens.add(new Token(TokenKind.LITERAL_STRING, this.subArray(start, this.pos), start, this.pos));
        } else {
            subarray = this.subArray(start, this.pos);
            this.tokens.add(new Token(TokenKind.IDENTIFIER, subarray, start, this.pos));
        }
    }

    protected boolean sameQuotes(int pos1, int pos2) {
        if (this.toProcess[pos1] == '\'') {
            return this.toProcess[pos2] == '\'';
        }
        if (this.toProcess[pos1] == '\"') {
            return this.toProcess[pos2] == '\"';
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.expressionString).append("\n");
        for (int i = 0; i < this.pos; ++i) {
            s.append(" ");
        }
        s.append("^\n");
        s.append(this.tokens).append("\n");
        return s.toString();
    }

    public void raiseException(DSLMessage message, Object ... inserts) {
        throw new ParseException(this.expressionString, this.pos, message, inserts);
    }

    protected void addLinebreak() {
        int[] newLinebreaks = new int[this.linebreaks.length + 1];
        System.arraycopy(this.linebreaks, 0, newLinebreaks, 0, this.linebreaks.length);
        newLinebreaks[this.linebreaks.length] = this.pos++;
        this.linebreaks = newLinebreaks;
    }

    static {
        int ch = 48;
        while (ch <= 57) {
            int n = ch++;
            flags[n] = (byte)(flags[n] | 3);
        }
        ch = 65;
        while (ch <= 70) {
            int n = ch++;
            flags[n] = (byte)(flags[n] | 2);
        }
        ch = 97;
        while (ch <= 102) {
            int n = ch++;
            flags[n] = (byte)(flags[n] | 2);
        }
        ch = 65;
        while (ch <= 90) {
            int n = ch++;
            flags[n] = (byte)(flags[n] | 4);
        }
        ch = 97;
        while (ch <= 122) {
            int n = ch++;
            flags[n] = (byte)(flags[n] | 4);
        }
    }
}

