/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.Arrays;
import java.util.Properties;
import org.springframework.cloud.dataflow.core.dsl.ArgumentNode;
import org.springframework.cloud.dataflow.core.dsl.AstNode;
import org.springframework.cloud.dataflow.core.dsl.LabelNode;

public class AppNode
extends AstNode {
    private static final ArgumentNode[] NO_ARGUMENTS = new ArgumentNode[0];
    protected final String appName;
    protected LabelNode label;
    protected ArgumentNode[] arguments;
    protected boolean isUnboundStreamApp = true;

    public AppNode(LabelNode label, String appName, int startPos, int endPos, ArgumentNode[] arguments) {
        super(startPos, endPos);
        this.label = label;
        this.appName = appName;
        if (arguments != null) {
            this.arguments = Arrays.copyOf(arguments, arguments.length);
            this.endPos = this.arguments[this.arguments.length - 1].endPos;
        } else {
            this.arguments = NO_ARGUMENTS;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.label != null) {
            s.append(this.label.toString());
            s.append(" ");
        }
        s.append(this.appName);
        if (this.arguments != null) {
            for (ArgumentNode argumentNode : this.arguments) {
                s.append(" --").append(argumentNode.getName()).append("=").append(argumentNode.getValue());
            }
        }
        return s.toString();
    }

    @Override
    public String stringify(boolean includePositionalInfo) {
        StringBuilder s = new StringBuilder();
        s.append("(");
        if (this.label != null) {
            s.append(this.label.stringify(includePositionalInfo));
            s.append(" ");
        }
        s.append("AppNode:").append(this.appName);
        if (this.arguments != null) {
            for (ArgumentNode argumentNode : this.arguments) {
                s.append(" --").append(argumentNode.getName()).append("=").append(argumentNode.getValue());
            }
        }
        if (includePositionalInfo) {
            s.append(":");
            s.append(this.getStartPos()).append(">").append(this.getEndPos());
        }
        s.append(")");
        return s.toString();
    }

    public String getName() {
        return this.appName;
    }

    public ArgumentNode[] getArguments() {
        return this.arguments;
    }

    public boolean hasArguments() {
        return this.arguments != null;
    }

    public String getLabelName() {
        return this.label != null ? this.label.getLabelName() : this.appName;
    }

    public Properties getArgumentsAsProperties() {
        Properties props = new Properties();
        if (this.arguments != null) {
            for (ArgumentNode argumentNode : this.arguments) {
                props.put(argumentNode.getName(), argumentNode.getValue());
            }
        }
        return props;
    }

    public void setUnboundStreamApp(boolean b) {
        this.isUnboundStreamApp = b;
    }

    public boolean isUnboundStreamApp() {
        return this.isUnboundStreamApp;
    }
}

