/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.List;
import org.springframework.cloud.dataflow.core.dsl.AppNode;
import org.springframework.cloud.dataflow.core.dsl.AstNode;
import org.springframework.cloud.dataflow.core.dsl.SinkDestinationNode;
import org.springframework.cloud.dataflow.core.dsl.SourceDestinationNode;

public class StreamNode
extends AstNode {
    protected final String streamText;
    protected final String streamName;
    protected final List<AppNode> appNodes;
    protected SourceDestinationNode sourceDestinationNode;
    protected SinkDestinationNode sinkDestinationNode;

    public StreamNode(String streamText, String streamName, List<AppNode> appNodes, SourceDestinationNode sourceDestinationNode, SinkDestinationNode sinkDestinationNode) {
        super(appNodes.get(0).getStartPos(), appNodes.get(appNodes.size() - 1).getEndPos());
        this.streamText = streamText;
        this.streamName = streamName;
        this.appNodes = appNodes;
        this.sourceDestinationNode = sourceDestinationNode;
        this.sinkDestinationNode = sinkDestinationNode;
    }

    @Override
    public String stringify(boolean includePositionalInfo) {
        StringBuilder s = new StringBuilder();
        s.append("[");
        if (this.getStreamName() != null) {
            s.append(this.getStreamName()).append(" = ");
        }
        if (this.sourceDestinationNode != null) {
            s.append(this.sourceDestinationNode.stringify(includePositionalInfo));
        }
        for (AppNode appNode : this.appNodes) {
            s.append(appNode.stringify(includePositionalInfo));
        }
        if (this.sinkDestinationNode != null) {
            s.append(this.sinkDestinationNode.stringify(includePositionalInfo));
        }
        s.append("]");
        return s.toString();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.getStreamName() != null) {
            s.append(this.getStreamName()).append(" = ");
        }
        if (this.sourceDestinationNode != null) {
            s.append(this.sourceDestinationNode.toString());
        }
        for (int m = 0; m < this.appNodes.size(); ++m) {
            AppNode appNode = this.appNodes.get(m);
            s.append(appNode.toString());
            if (m + 1 >= this.appNodes.size()) continue;
            if (appNode.isUnboundStreamApp()) {
                s.append(" || ");
                continue;
            }
            s.append(" | ");
        }
        if (this.sinkDestinationNode != null) {
            s.append(this.sinkDestinationNode.toString());
        }
        return s.toString();
    }

    public List<AppNode> getAppNodes() {
        return this.appNodes;
    }

    public SourceDestinationNode getSourceDestinationNode() {
        return this.sourceDestinationNode;
    }

    public SinkDestinationNode getSinkDestinationNode() {
        return this.sinkDestinationNode;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public AppNode getApp(String appName) {
        for (AppNode appNode : this.appNodes) {
            if (!appNode.getName().equals(appName)) continue;
            return appNode;
        }
        return null;
    }

    public int getIndexOfLabel(String labelOrAppName) {
        for (int m = 0; m < this.appNodes.size(); ++m) {
            AppNode appNode = this.appNodes.get(m);
            if (!appNode.getLabelName().equals(labelOrAppName)) continue;
            return m;
        }
        return -1;
    }

    public String getStreamData() {
        return this.toString();
    }

    public String getStreamText() {
        return this.streamText;
    }

    public String getName() {
        return this.streamName;
    }
}

