/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import org.springframework.cloud.dataflow.core.dsl.AbstractTokenizer;
import org.springframework.cloud.dataflow.core.dsl.DSLMessage;
import org.springframework.cloud.dataflow.core.dsl.ParseException;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;

class TaskTokenizer
extends AbstractTokenizer {
    TaskTokenizer() {
    }

    @Override
    protected void process() {
        boolean justProcessedEquals = false;
        block20: while (this.pos < this.max) {
            char ch = this.toProcess[this.pos];
            if (justProcessedEquals) {
                if (!this.isWhitespace(ch) && ch != '\u0000') {
                    if (this.isArgValueIdentifierTerminator(ch, false)) {
                        this.raiseException(DSLMessage.EXPECTED_ARGUMENT_VALUE, Character.valueOf(ch));
                    }
                    this.lexArgValueIdentifier();
                }
                justProcessedEquals = false;
                continue;
            }
            if (this.isAlphabetic(ch) || this.isDigit(ch) || ch == '_' || ch == '$') {
                this.lexIdentifier();
                continue;
            }
            switch (ch) {
                case '-': {
                    if (this.isTwoCharToken(TokenKind.DOUBLE_MINUS)) {
                        this.pushPairToken(TokenKind.DOUBLE_MINUS);
                        continue block20;
                    }
                    if (this.isTwoCharToken(TokenKind.ARROW)) {
                        this.pushPairToken(TokenKind.ARROW);
                        continue block20;
                    }
                    throw new ParseException(this.expressionString, this.pos, DSLMessage.MISSING_CHARACTER, "-");
                }
                case '&': {
                    if (this.isTwoCharToken(TokenKind.ANDAND)) {
                        this.pushPairToken(TokenKind.ANDAND);
                        continue block20;
                    }
                    this.raiseException(DSLMessage.TASK_DOUBLE_AND_REQUIRED, new Object[0]);
                    continue block20;
                }
                case '|': {
                    if (this.isTwoCharToken(TokenKind.DOUBLEPIPE)) {
                        this.pushPairToken(TokenKind.DOUBLEPIPE);
                        continue block20;
                    }
                    this.raiseException(DSLMessage.TASK_DOUBLE_OR_REQUIRED, new Object[0]);
                    continue block20;
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    ++this.pos;
                    continue block20;
                }
                case '.': {
                    this.pushCharToken(TokenKind.DOT);
                    continue block20;
                }
                case '\n': {
                    this.addLinebreak();
                    continue block20;
                }
                case '<': {
                    this.pushCharToken(TokenKind.LT);
                    continue block20;
                }
                case '>': {
                    this.pushCharToken(TokenKind.GT);
                    continue block20;
                }
                case '(': {
                    this.pushCharToken(TokenKind.OPEN_PAREN);
                    continue block20;
                }
                case ')': {
                    this.pushCharToken(TokenKind.CLOSE_PAREN);
                    continue block20;
                }
                case '\'': {
                    this.lexQuotedStringLiteral();
                    continue block20;
                }
                case '\"': {
                    this.lexDoubleQuotedStringLiteral();
                    continue block20;
                }
                case ':': {
                    this.pushCharToken(TokenKind.COLON);
                    continue block20;
                }
                case '=': {
                    justProcessedEquals = true;
                    this.pushCharToken(TokenKind.EQUALS);
                    continue block20;
                }
                case '*': {
                    this.pushCharToken(TokenKind.STAR);
                    continue block20;
                }
                case ';': {
                    this.pushCharToken(TokenKind.SEMICOLON);
                    continue block20;
                }
                case '\u0000': {
                    ++this.pos;
                    continue block20;
                }
                case '\\': {
                    this.raiseException(DSLMessage.UNEXPECTED_ESCAPE_CHAR, new Object[0]);
                }
            }
            this.raiseException(DSLMessage.TASK_UNEXPECTED_DATA, Character.valueOf(ch).toString());
        }
    }

    @Override
    protected void lexIdentifier() {
        int start = this.pos;
        do {
            ++this.pos;
        } while ((this.toProcess[this.pos] != '-' || this.toProcess[this.pos + 1] != '>') && this.isIdentifier(this.toProcess[this.pos]));
        char[] subarray = this.subArray(start, this.pos);
        this.tokens.add(new Token(TokenKind.IDENTIFIER, subarray, start, this.pos));
    }
}

