/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.cloud.dataflow.core.dsl.DSLMessage;
import org.springframework.cloud.dataflow.core.dsl.LabelledTaskNode;
import org.springframework.cloud.dataflow.core.dsl.SplitNode;
import org.springframework.cloud.dataflow.core.dsl.TaskAppNode;
import org.springframework.cloud.dataflow.core.dsl.TaskValidationProblem;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;
import org.springframework.cloud.dataflow.core.dsl.TransitionNode;

public class TaskValidatorVisitor
extends TaskVisitor {
    private String taskDsl;
    private List<TaskValidationProblem> problems = new ArrayList<TaskValidationProblem>();
    private List<LabelledTaskNode> recordedSequences = new ArrayList<LabelledTaskNode>();
    private Set<TransitionNode> transitionsTargetingLabels = new HashSet<TransitionNode>();
    private Set<String> labelsDefined = new HashSet<String>();
    private Set<String> taskAppNamesWithoutLabels = new HashSet<String>();

    public List<TaskValidationProblem> getProblems() {
        return this.problems;
    }

    public boolean hasProblems() {
        return this.problems.size() != 0;
    }

    public void reset() {
        this.problems.clear();
        this.recordedSequences.clear();
        this.transitionsTargetingLabels.clear();
        this.labelsDefined.clear();
        this.taskAppNamesWithoutLabels.clear();
    }

    @Override
    public void startVisit(String taskName, String taskDsl) {
        this.taskDsl = taskDsl;
    }

    @Override
    public boolean preVisitSequence(LabelledTaskNode firstNode, int sequenceNumber) {
        if (sequenceNumber > 0 && !firstNode.hasLabel()) {
            this.pushProblem(firstNode.getStartPos(), DSLMessage.TASK_VALIDATION_SECONDARY_SEQUENCES_MUST_BE_NAMED);
        }
        this.recordedSequences.add(firstNode);
        return true;
    }

    @Override
    public boolean preVisit(SplitNode split) {
        if (split.hasLabel()) {
            String labelString = split.getLabelString();
            if (this.labelsDefined.contains(labelString)) {
                this.pushProblem(split.getLabel().startPos, DSLMessage.TASK_VALIDATION_DUPLICATE_LABEL);
            }
            this.labelsDefined.add(labelString);
        }
        return true;
    }

    @Override
    public void visit(TaskAppNode taskApp) {
        if (taskApp.hasLabel()) {
            String labelString = taskApp.getLabelString();
            if (this.labelsDefined.contains(labelString)) {
                this.pushProblem(taskApp.getLabel().startPos, DSLMessage.TASK_VALIDATION_DUPLICATE_LABEL);
            }
            this.labelsDefined.add(labelString);
            if (this.taskAppNamesWithoutLabels.contains(labelString)) {
                this.pushProblem(taskApp.getLabel().startPos, DSLMessage.TASK_VALIDATION_LABEL_CLASHES_WITH_TASKAPP_NAME);
            }
        } else {
            String name = taskApp.getName();
            if (this.labelsDefined.contains(name)) {
                this.pushProblem(taskApp.startPos, DSLMessage.TASK_VALIDATION_APP_NAME_CLASHES_WITH_LABEL);
            }
            if (this.taskAppNamesWithoutLabels.contains(name)) {
                this.pushProblem(taskApp.startPos, DSLMessage.TASK_VALIDATION_APP_NAME_ALREADY_IN_USE);
            }
            this.taskAppNamesWithoutLabels.add(taskApp.getName());
        }
    }

    @Override
    public void visit(TransitionNode transition) {
        if (!transition.isTargetApp()) {
            this.transitionsTargetingLabels.add(transition);
        }
        if (transition.isTargetApp()) {
            TaskAppNode taskApp = transition.getTargetApp();
            if (taskApp.hasLabel()) {
                String labelString = taskApp.getLabelString();
                if (this.labelsDefined.contains(labelString)) {
                    this.pushProblem(taskApp.getLabel().startPos, DSLMessage.TASK_VALIDATION_DUPLICATE_LABEL);
                }
                this.labelsDefined.add(labelString);
                if (this.taskAppNamesWithoutLabels.contains(labelString)) {
                    this.pushProblem(taskApp.getLabel().startPos, DSLMessage.TASK_VALIDATION_LABEL_CLASHES_WITH_TASKAPP_NAME);
                }
            } else {
                String name = taskApp.getName();
                if (this.labelsDefined.contains(name)) {
                    this.pushProblem(taskApp.startPos, DSLMessage.TASK_VALIDATION_APP_NAME_CLASHES_WITH_LABEL);
                }
                if (this.taskAppNamesWithoutLabels.contains(name)) {
                    this.pushProblem(taskApp.startPos, DSLMessage.TASK_VALIDATION_APP_NAME_ALREADY_IN_USE);
                }
                this.taskAppNamesWithoutLabels.add(taskApp.getName());
            }
        }
    }

    @Override
    public void endVisit() {
        for (TransitionNode transitionTargetingLabel : this.transitionsTargetingLabels) {
            if (this.labelsDefined.contains(transitionTargetingLabel.getTargetLabel())) continue;
            this.pushProblem(transitionTargetingLabel.startPos, DSLMessage.TASK_VALIDATION_TRANSITION_TARGET_LABEL_UNDEFINED);
        }
    }

    private void pushProblem(int pos, DSLMessage message) {
        this.problems.add(new TaskValidationProblem(this.taskDsl, pos, message));
    }
}

