/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.Collections;
import java.util.List;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.core.dsl.DSLMessage;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;

public class Tokens {
    private final String expression;
    private final List<Token> tokenStream;
    private int[] linebreaks;
    private int position = 0;
    private int lastGoodPosition = 0;

    Tokens(String expression, List<Token> tokens, int[] linebreaks) {
        this.expression = expression;
        this.linebreaks = linebreaks;
        this.tokenStream = Collections.unmodifiableList(tokens);
    }

    public String getExpression() {
        return this.expression;
    }

    public int decrementPosition() {
        return --this.position;
    }

    public int position() {
        return this.position;
    }

    public List<Token> getTokenStream() {
        return this.tokenStream;
    }

    protected boolean lookAhead(int distance, TokenKind desiredTokenKind) {
        if (this.position + distance >= this.tokenStream.size()) {
            return false;
        }
        Token t = this.tokenStream.get(this.position + distance);
        return t.kind == desiredTokenKind;
    }

    public boolean hasNext() {
        return this.position < this.tokenStream.size();
    }

    public Token peek() {
        return this.hasNext() ? this.tokenStream.get(this.position) : null;
    }

    protected Token peek(int howFarAhead) {
        if (this.position + howFarAhead >= 0 && this.position + howFarAhead < this.tokenStream.size()) {
            return this.tokenStream.get(this.position + howFarAhead);
        }
        return null;
    }

    public boolean peek(TokenKind desiredTokenKind) {
        return this.peek(desiredTokenKind, false);
    }

    private boolean peek(TokenKind desiredTokenKind, boolean consumeIfMatched) {
        if (!this.hasNext()) {
            return false;
        }
        Token t = this.peek();
        if (t.kind == desiredTokenKind) {
            if (consumeIfMatched) {
                ++this.position;
            }
            return true;
        }
        return false;
    }

    public Token next() {
        if (!this.hasNext()) {
            this.raiseException(this.expression.length(), DSLMessage.OOD, new Object[0]);
        }
        return this.tokenStream.get(this.position++);
    }

    public Token eat(TokenKind expectedKind) {
        Token t = this.next();
        if (t == null) {
            this.raiseException(this.expression.length(), DSLMessage.OOD, new Object[0]);
        }
        if (t.kind != expectedKind) {
            this.raiseException(t.startPos, DSLMessage.NOT_EXPECTED_TOKEN, expectedKind.toString().toLowerCase(), t.data == null ? new String(t.getKind().tokenChars).toLowerCase() : t.data);
        }
        return t;
    }

    protected Token eat() {
        Token t = this.next();
        if (t == null) {
            this.raiseException(this.expression.length(), DSLMessage.OOD, new Object[0]);
        }
        return t;
    }

    public boolean isNextAdjacent() {
        if (!this.hasNext()) {
            return false;
        }
        Token last = this.tokenStream.get(this.position - 1);
        Token next = this.tokenStream.get(this.position);
        return next.startPos == last.endPos;
    }

    protected void checkpoint() {
        this.lastGoodPosition = this.position;
    }

    public void raiseException(int position, DSLMessage message, Object ... inserts) {
        throw new CheckPointedParseException(this.expression, position, this.position, this.lastGoodPosition, this.tokenStream, message, inserts);
    }

    public int getLine(Token token) {
        int lb;
        int tokenStart = token.startPos;
        for (lb = 0; lb < this.linebreaks.length && this.linebreaks[lb] < tokenStart; ++lb) {
        }
        return lb;
    }
}

