/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.dataflow.core.dsl.AppNode;
import org.springframework.cloud.dataflow.core.dsl.ArgumentNode;
import org.springframework.cloud.dataflow.core.dsl.DSLMessage;
import org.springframework.cloud.dataflow.core.dsl.LabelNode;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.core.dsl.Tokens;

public class AppParser {
    protected final Tokens tokens;

    public AppParser(Tokens tokens) {
        this.tokens = tokens;
    }

    public Tokens getTokens() {
        return this.tokens;
    }

    protected AppNode eatApp() {
        Token name;
        Token label = null;
        if (this.tokens.peek(TokenKind.COLON) && this.tokens.getTokenStream().size() == 1) {
            this.tokens.raiseException(this.tokens.peek().startPos, DSLMessage.EXPECTED_STREAM_NAME_AFTER_LABEL_COLON, new Object[0]);
        }
        if (!(name = this.tokens.next()).isKind(TokenKind.IDENTIFIER)) {
            this.tokens.raiseException(name.startPos, DSLMessage.EXPECTED_APPNAME, name.data != null ? name.data : new String(name.getKind().tokenChars));
        }
        if (this.tokens.peek(TokenKind.COLON) && this.tokens.isNextAdjacent()) {
            this.tokens.next();
            if (this.tokens.isNextAdjacent()) {
                this.tokens.raiseException(this.tokens.peek().startPos, DSLMessage.EXPECTED_WHITESPACE_AFTER_LABEL_COLON, new Object[0]);
            }
            label = name;
            name = this.tokens.eat(TokenKind.IDENTIFIER);
            if (this.tokens.peek(TokenKind.COLON) && this.tokens.isNextAdjacent()) {
                this.tokens.raiseException(name.startPos, DSLMessage.NO_DOUBLE_LABELS, new Object[0]);
            }
        }
        Token appName = name;
        this.tokens.checkpoint();
        ArgumentNode[] args = this.eatAppArgs();
        int startPos = label != null ? label.startPos : appName.startPos;
        return this.makeAppNode(this.toLabelNode(label), appName.data, startPos, appName.endPos, args);
    }

    protected ArgumentNode[] eatAppArgs() {
        ArrayList<ArgumentNode> args = null;
        if (this.tokens.peek(TokenKind.DOUBLE_MINUS) && this.tokens.isNextAdjacent()) {
            this.tokens.raiseException(this.tokens.peek().startPos, DSLMessage.EXPECTED_WHITESPACE_AFTER_APP_BEFORE_ARGUMENT, new Object[0]);
        }
        while (this.tokens.peek(TokenKind.DOUBLE_MINUS)) {
            Token dashDash = this.tokens.next();
            if (this.tokens.peek(TokenKind.IDENTIFIER) && !this.tokens.isNextAdjacent()) {
                this.tokens.raiseException(this.tokens.peek().startPos, DSLMessage.NO_WHITESPACE_BEFORE_ARG_NAME, new Object[0]);
            }
            List<Token> argNameComponents = this.eatDottedName();
            if (this.tokens.peek(TokenKind.EQUALS) && !this.tokens.isNextAdjacent()) {
                this.tokens.raiseException(this.tokens.peek().startPos, DSLMessage.NO_WHITESPACE_BEFORE_ARG_EQUALS, new Object[0]);
            }
            this.tokens.eat(TokenKind.EQUALS);
            if (this.tokens.peek(TokenKind.IDENTIFIER) && !this.tokens.isNextAdjacent()) {
                this.tokens.raiseException(this.tokens.peek().startPos, DSLMessage.NO_WHITESPACE_BEFORE_ARG_VALUE, new Object[0]);
            }
            Token t = this.tokens.peek();
            String argValue = this.eatArgValue();
            this.tokens.checkpoint();
            if (args == null) {
                args = new ArrayList<ArgumentNode>();
            }
            args.add(new ArgumentNode(this.toData(argNameComponents), argValue, dashDash.startPos, t.endPos));
        }
        return args == null ? null : args.toArray(new ArgumentNode[args.size()]);
    }

    protected String eatArgValue() {
        Token t = this.tokens.next();
        String argValue = null;
        if (t.getKind() == TokenKind.IDENTIFIER) {
            argValue = t.data;
        } else if (t.getKind() == TokenKind.LITERAL_STRING) {
            String quotesUsed = t.data.substring(0, 1);
            argValue = t.data.substring(1, t.data.length() - 1).replace(quotesUsed + quotesUsed, quotesUsed);
        } else {
            this.tokens.raiseException(t.startPos, DSLMessage.EXPECTED_ARGUMENT_VALUE, t.data);
        }
        return argValue;
    }

    protected List<Token> eatDottedName() {
        ArrayList<Token> result = new ArrayList<Token>(3);
        Token name = this.tokens.next();
        if (!name.isKind(TokenKind.IDENTIFIER)) {
            this.tokens.raiseException(name.startPos, DSLMessage.NOT_EXPECTED_TOKEN, name.data != null ? name.data : new String(name.getKind().tokenChars));
        }
        result.add(name);
        while (this.tokens.peek(TokenKind.DOT)) {
            if (!this.tokens.isNextAdjacent()) {
                this.tokens.raiseException(this.tokens.peek().startPos, DSLMessage.NO_WHITESPACE_IN_DOTTED_NAME, new Object[0]);
            }
            result.add(this.tokens.next());
            if (this.tokens.peek(TokenKind.IDENTIFIER) && !this.tokens.isNextAdjacent()) {
                this.tokens.raiseException(this.tokens.peek().startPos, DSLMessage.NO_WHITESPACE_IN_DOTTED_NAME, new Object[0]);
            }
            result.add(this.tokens.eat(TokenKind.IDENTIFIER));
        }
        return result;
    }

    protected LabelNode toLabelNode(Token label) {
        return label == null ? null : new LabelNode(label.data, label.startPos, label.endPos);
    }

    protected String toData(Iterable<Token> iterable) {
        StringBuilder result = new StringBuilder();
        for (Token t : iterable) {
            if (t.getKind().hasPayload()) {
                result.append(t.data);
                continue;
            }
            result.append(t.getKind().tokenChars);
        }
        return result.toString();
    }

    protected List<String> tokenListToStringList(List<Token> tokens) {
        if (tokens.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> data = new ArrayList<String>();
        for (Token token : tokens) {
            data.add(token.data);
        }
        return data;
    }

    protected String toString(Token t) {
        return t.getKind().hasPayload() ? t.stringValue() : new String(t.kind.getTokenChars());
    }

    protected boolean isValidName(String name) {
        if (name.length() == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int max = name.length();
        for (int i = 1; i < max; ++i) {
            char ch = name.charAt(i);
            if (Character.isJavaIdentifierPart(ch) || ch == '-') continue;
            return false;
        }
        return true;
    }

    protected AppNode makeAppNode(LabelNode label, String appName, int startPos, int endPos, ArgumentNode[] arguments) {
        return new AppNode(label, appName, startPos, endPos, arguments);
    }
}

