/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.List;
import org.springframework.cloud.dataflow.core.dsl.DSLMessage;
import org.springframework.cloud.dataflow.core.dsl.ParseException;
import org.springframework.cloud.dataflow.core.dsl.Token;

public class CheckPointedParseException
extends ParseException {
    private int checkpointPointer = -1;
    private List<Token> tokens;
    private int tokenPointer;

    public CheckPointedParseException(String expressionString, int textPosition, int tokenPointer, int checkpointPointer, List<Token> tokens, DSLMessage message, Object ... inserts) {
        super(expressionString, textPosition, message, inserts);
        this.tokenPointer = tokenPointer;
        this.checkpointPointer = checkpointPointer;
        this.tokens = tokens;
    }

    @Override
    public String getMessage() {
        StringBuilder s = new StringBuilder();
        if (this.message != null) {
            s.append(this.message.formatMessage(this.position, this.inserts));
        } else {
            s.append(super.getMessage());
        }
        int startOfLine = this.getStartOfLine(this.position);
        if (this.expressionString != null && this.expressionString.length() > 0) {
            s.append("\n").append(this.expressionString.substring(startOfLine)).append("\n");
        }
        int offset = this.position - startOfLine;
        if (this.checkpointPointer > 0 && offset >= 0 && this.getStartOfLine(this.checkpointPointer) == startOfLine) {
            int checkpointPosition = this.getCheckpointPosition();
            checkpointPosition -= this.getStartOfLine(checkpointPosition);
            offset -= checkpointPosition;
            for (int i = 0; i < checkpointPosition; ++i) {
                s.append(' ');
            }
            s.append("*");
            --offset;
        }
        if (offset >= 0) {
            for (int i = 0; i < offset; ++i) {
                s.append(' ');
            }
            s.append("^\n");
        }
        return s.toString();
    }

    private int getStartOfLine(int position) {
        int lineStart = 0;
        for (int p = 0; p < position; ++p) {
            if (this.expressionString.charAt(p) != '\n') continue;
            lineStart = p + 1;
        }
        return lineStart;
    }

    public int getCheckpointPosition() {
        return this.checkpointPointer == 0 ? 0 : this.tokens.get((int)(this.checkpointPointer - 1)).endPos;
    }

    public String getExpressionStringUntilCheckpoint() {
        return this.expressionString.substring(0, this.getCheckpointPosition());
    }

    public int getCheckpointPointer() {
        return this.checkpointPointer;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public int getTokenPointer() {
        return this.tokenPointer;
    }
}

