/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.Collections;
import java.util.List;
import org.springframework.cloud.dataflow.core.dsl.LabelledTaskNode;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;

public class FlowNode
extends LabelledTaskNode {
    private List<LabelledTaskNode> series;

    FlowNode(List<LabelledTaskNode> nodes) {
        super(nodes.get(0).getStartPos(), nodes.get(nodes.size() - 1).getEndPos());
        this.series = Collections.unmodifiableList(nodes);
    }

    @Override
    public String stringify(boolean includePositionInfo) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.series.size(); ++i) {
            if (i > 0) {
                s.append(" ").append(TokenKind.ANDAND.tokenChars).append(" ");
            }
            s.append(this.series.get(i).stringify(includePositionInfo));
        }
        return s.toString();
    }

    @Override
    public int getSeriesLength() {
        return this.series.size();
    }

    @Override
    public List<LabelledTaskNode> getSeries() {
        return this.series;
    }

    @Override
    public LabelledTaskNode getSeriesElement(int index) {
        return this.series.get(index);
    }

    @Override
    public boolean isFlow() {
        return true;
    }

    public String toString() {
        return "[Flow:" + this.stringify(true) + "]";
    }

    @Override
    public void accept(TaskVisitor visitor) {
        boolean cont = visitor.preVisit(this);
        if (!cont) {
            return;
        }
        visitor.visit(this);
        for (LabelledTaskNode labelledTaskNode : this.series) {
            labelledTaskNode.accept(visitor);
        }
        visitor.postVisit(this);
    }
}

