/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.springframework.cloud.dataflow.core.dsl.ArgumentNode;
import org.springframework.cloud.dataflow.core.dsl.FlowNode;
import org.springframework.cloud.dataflow.core.dsl.LabelledTaskNode;
import org.springframework.cloud.dataflow.core.dsl.SplitNode;
import org.springframework.cloud.dataflow.core.dsl.TaskAppNode;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;
import org.springframework.cloud.dataflow.core.dsl.TransitionNode;
import org.springframework.cloud.dataflow.core.dsl.graph.Graph;
import org.springframework.cloud.dataflow.core.dsl.graph.Link;
import org.springframework.cloud.dataflow.core.dsl.graph.Node;

public class GraphGeneratorVisitor
extends TaskVisitor {
    private int nextNodeId = 0;
    private Stack<Context> contexts = new Stack();
    private List<Sequence> sequences = new ArrayList<Sequence>();
    private int currentSequence;
    private String currentTaskAppId;
    private Map<String, Node> existingNodesToReuse;

    public Graph getGraph() {
        if (this.sequences.size() == 0) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            ArrayList<Link> links = new ArrayList<Link>();
            nodes.add(new Node("0", "START"));
            nodes.add(new Node("1", "END"));
            links.add(new Link("0", "1"));
            return new Graph(nodes, links);
        }
        Sequence s = this.sequences.get(0);
        Graph g = new Graph(s.nodes, s.links);
        return g;
    }

    private String nextId() {
        return Integer.toString(this.nextNodeId++);
    }

    @Override
    public boolean preVisitSequence(LabelledTaskNode firstNode, int sequenceNumber) {
        Node sequenceStartNode = new Node(this.nextId(), "START");
        this.currentSequence = sequenceNumber;
        this.sequences.add(new Sequence(sequenceNumber, firstNode.getLabelString(), sequenceStartNode));
        this.contexts.push(new Context(true, false, sequenceStartNode.id, null));
        return true;
    }

    @Override
    public void postVisitSequence(LabelledTaskNode firstNode, int sequenceNumber) {
        String endId = this.nextId();
        Node endNode = new Node(endId, "END");
        this.addLinks(endId);
        this.addNode(endNode);
        this.contexts.pop();
    }

    private void addLink(Link link) {
        this.sequences.get((int)this.currentSequence).links.add(link);
    }

    private void addNode(Node node) {
        this.sequences.get((int)this.currentSequence).nodes.add(node);
    }

    private void addLinks(String target) {
        List<String> openNodes = this.currentContext().getDanglingNodes();
        for (int i = 0; i < openNodes.size(); ++i) {
            this.addLink(new Link(openNodes.get(i), target));
        }
    }

    @Override
    public void endVisit() {
        if (this.sequences.size() > 0) {
            Sequence mainSequence = this.sequences.get(0);
            for (int tooMany = 0; !mainSequence.outstandingTransitions.isEmpty() && tooMany < 50; ++tooMany) {
                List<Context.TransitionTarget> nextTransitions = this.findNextTransitions(mainSequence.outstandingTransitions);
                mainSequence.outstandingTransitions.removeAll(nextTransitions);
                Sequence sequence = this.findSequence(nextTransitions.get((int)0).label);
                if (sequence == null) {
                    throw new IllegalStateException("Out of flow transition? " + nextTransitions.get(0));
                }
                this.inline(mainSequence, sequence, nextTransitions);
                Iterator<Context.TransitionTarget> iter = mainSequence.outstandingTransitions.iterator();
                while (iter.hasNext()) {
                    Context.TransitionTarget transitionTarget = iter.next();
                    FlowNode flowInWhichTransitionOccurring = transitionTarget.flow;
                    Map<String, Node> candidates = mainSequence.labeledNodesInEachFlow.get(flowInWhichTransitionOccurring);
                    for (Map.Entry<String, Node> candidate : candidates.entrySet()) {
                        if (!candidate.getKey().equals(transitionTarget.label)) continue;
                        mainSequence.links.add(new Link(transitionTarget.nodeId, candidate.getValue().id, transitionTarget.onState));
                        iter.remove();
                    }
                }
            }
        }
    }

    private List<Context.TransitionTarget> findNextTransitions(List<Context.TransitionTarget> transitions) {
        if (transitions.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Context.TransitionTarget> sameTarget = new ArrayList<Context.TransitionTarget>();
        sameTarget.add(transitions.get(0));
        for (int i = 1; i < transitions.size(); ++i) {
            Context.TransitionTarget tt = transitions.get(i);
            if (!transitions.get((int)0).flow.equals(tt.flow) || !transitions.get((int)0).label.equals(tt.label)) continue;
            sameTarget.add(tt);
        }
        return sameTarget;
    }

    private Sequence findSequence(String label) {
        for (Sequence sequence : this.sequences) {
            if (!label.equals(sequence.label)) continue;
            return sequence;
        }
        return null;
    }

    private void inline(Sequence mainSequence, Sequence sequence, List<Context.TransitionTarget> transitionTargets) {
        int i;
        HashMap<String, String> nodeIds = new HashMap<String, String>();
        Node startNode = sequence.nodes.get(0);
        Node endNode = sequence.nodes.get(sequence.nodes.size() - 1);
        for (i = 1; i < sequence.nodes.size() - 1; ++i) {
            Node n = sequence.nodes.get(i);
            Node newNode = new Node(this.nextId(), n.name, n.properties);
            nodeIds.put(n.id, newNode.id);
            mainSequence.nodes.add(newNode);
        }
        for (i = 0; i < sequence.links.size(); ++i) {
            Link existingLink = sequence.links.get(i);
            String existingLinkFrom = existingLink.from;
            String existingLinkTo = existingLink.to;
            Link newLink = null;
            if (existingLinkFrom.equals(startNode.id)) {
                for (Context.TransitionTarget transitionTarget : transitionTargets) {
                    newLink = new Link(transitionTarget.nodeId, (String)nodeIds.get(existingLinkTo), transitionTarget.onState);
                    mainSequence.links.add(newLink);
                }
                continue;
            }
            if (existingLinkTo.equals(endNode.id)) {
                Context.TransitionTarget tt = transitionTargets.get(0);
                String string = tt.lastNodeId;
                ArrayList<Link> newLinks = new ArrayList<Link>();
                for (Link link : mainSequence.links) {
                    if (!link.from.equals(string)) continue;
                    newLinks.add(new Link((String)nodeIds.get(existingLinkFrom), link.to, link.getTransitionName()));
                }
                mainSequence.links.addAll(newLinks);
                continue;
            }
            newLink = new Link((String)nodeIds.get(existingLinkFrom), (String)nodeIds.get(existingLinkTo), existingLink.getTransitionName());
            mainSequence.links.add(newLink);
        }
        ArrayList<Context.TransitionTarget> rewrittenTransitions = new ArrayList<Context.TransitionTarget>();
        for (Context.TransitionTarget looseEnd : sequence.outstandingTransitions) {
            Context.TransitionTarget tt = new Context.TransitionTarget((String)nodeIds.get(looseEnd.nodeId), looseEnd.onState, looseEnd.label);
            tt.flow = transitionTargets.get((int)0).flow;
            tt.lastNodeId = transitionTargets.get((int)0).lastNodeId;
            rewrittenTransitions.add(tt);
        }
        mainSequence.outstandingTransitions.addAll(rewrittenTransitions);
        FlowNode flowBeingInsertedInto = transitionTargets.get((int)0).flow;
        Map<String, Node> relevantFlowMapToUpdate = mainSequence.labeledNodesInEachFlow.get(flowBeingInsertedInto);
        Map<FlowNode, Map<String, Node>> labeledNodesInSequenceBeingInlined = sequence.labeledNodesInEachFlow;
        FlowNode primaryFlowInSequenceBeingInlined = sequence.primaryFlow;
        for (Map.Entry entry : labeledNodesInSequenceBeingInlined.entrySet()) {
            if (entry.getKey() == primaryFlowInSequenceBeingInlined) {
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    Node node = new Node((String)nodeIds.get(entry2.getKey()), ((Node)entry2.getValue()).name);
                    node.setLabel(((Node)entry2.getValue()).getLabel());
                    relevantFlowMapToUpdate.put((String)entry2.getKey(), node);
                }
                continue;
            }
            HashMap newMap = new HashMap();
            for (Map.Entry entry3 : ((Map)entry.getValue()).entrySet()) {
                Node n2 = new Node((String)nodeIds.get(entry3.getKey()), ((Node)entry3.getValue()).name);
                n2.setLabel(((Node)entry3.getValue()).getLabel());
                newMap.put(entry3.getKey(), n2);
            }
            mainSequence.labeledNodesInEachFlow.put((FlowNode)entry.getKey(), newMap);
        }
    }

    @Override
    public boolean preVisit(SplitNode split) {
        String startId;
        List<String> open = this.currentContext().getDanglingNodes();
        String string = startId = open.size() == 0 ? this.currentContext().startNodeId : open.get(0);
        if (open.size() > 1) {
            String syncId = this.nextId();
            Node node = new Node(syncId, "SYNC");
            this.addNode(node);
            for (String openid : open) {
                this.addLink(new Link(openid, syncId));
            }
            startId = syncId;
        }
        this.contexts.push(new Context(false, true, startId, split));
        return true;
    }

    @Override
    public void postVisit(SplitNode split) {
        List<String> openAtEndOfFlow = this.currentContext().getDanglingNodes();
        this.contexts.pop();
        this.currentContext().addDanglingNodes(true, openAtEndOfFlow);
    }

    @Override
    public boolean preVisit(FlowNode flow) {
        this.contexts.push(new Context(true, false, this.currentContext().startNodeId, flow));
        this.currentSequence().primaryFlow = flow;
        return true;
    }

    @Override
    public void postVisit(FlowNode flow) {
        List<Context.TransitionTarget> transitionTargets = this.currentContext().getTransitionTargets();
        for (Context.TransitionTarget tt : transitionTargets) {
            tt.lastNodeId = this.currentContext().getDanglingNodes().get(0);
            tt.flow = flow;
        }
        this.sequences.get((int)this.currentSequence).outstandingTransitions.addAll(transitionTargets);
        this.currentSequence().labeledNodesInEachFlow.put(flow, this.currentContext().nodesWithLabels);
        List<String> openAtEndOfFlow = this.currentContext().getDanglingNodes();
        List<String> otherExitNodes = this.currentContext().otherExits;
        this.contexts.pop();
        this.currentContext().addDanglingNodes(false, openAtEndOfFlow);
        this.currentContext().addDanglingNodes(false, otherExitNodes);
    }

    private Node findOrMakeNode(String name) {
        Node node = this.existingNodesToReuse.get(name);
        if (node == null) {
            node = new Node(this.nextId(), name);
            this.existingNodesToReuse.put(name, node);
            this.addNode(node);
        }
        return node;
    }

    @Override
    public void visit(TransitionNode transition) {
        if (transition.isTargetApp()) {
            if (transition.isSpecialTransition()) {
                if (transition.isFailTransition()) {
                    Node failNode = this.findOrMakeNode("$FAIL");
                    this.addLink(new Link(this.currentTaskAppId, failNode.id, transition.getStatusToCheck()));
                } else if (transition.isEndTransition()) {
                    Node endNode = this.findOrMakeNode("$END");
                    this.addLink(new Link(this.currentTaskAppId, endNode.id, transition.getStatusToCheck()));
                }
            } else {
                String key = this.toKey(transition.getTargetApp());
                Node n = this.existingNodesToReuse.get(key);
                boolean isCreated = false;
                if (n == null) {
                    String nextId = this.nextId();
                    n = new Node(nextId, transition.getTargetApp().getName(), this.toMap(transition.getTargetApp().getArguments()));
                    if (transition.getTargetApp().hasLabel()) {
                        n.setLabel(transition.getTargetApp().getLabelString());
                    }
                    this.existingNodesToReuse.put(key, n);
                    this.addNode(n);
                    isCreated = true;
                }
                this.addLink(new Link(this.currentTaskAppId, n.id, transition.getStatusToCheck()));
                if (isCreated) {
                    if (this.currentContext().isFlow) {
                        this.currentContext().addOtherExit(n.id);
                    } else {
                        this.currentContext().addDanglingNodes(false, n.id);
                    }
                }
            }
        } else {
            Node existingNode = this.currentContext().getNodeLabeled(transition.getTargetLabel());
            if (existingNode != null) {
                this.addLink(new Link(this.currentTaskAppId, existingNode.id, transition.getStatusToCheck()));
            } else {
                this.currentContext().addTransitionTarget(this.currentTaskAppId, transition.getStatusToCheck(), transition.getTargetLabel());
            }
        }
    }

    private Map<String, String> toMap(ArgumentNode[] arguments) {
        if (arguments == null) {
            return null;
        }
        HashMap<String, String> argumentsMap = new HashMap<String, String>();
        for (ArgumentNode argument : arguments) {
            argumentsMap.put(argument.getName(), argument.getValue());
        }
        return argumentsMap;
    }

    private String toKey(TaskAppNode targetApp) {
        StringBuilder key = new StringBuilder();
        if (targetApp.hasLabel()) {
            key.append(targetApp.getLabel()).append(">");
        }
        key.append(targetApp.getName());
        for (Map.Entry<String, String> argument : targetApp.getArgumentsAsMap().entrySet()) {
            key.append(":").append(argument.getKey()).append("=").append(argument.getValue());
        }
        return key.toString();
    }

    public Context currentContext() {
        return this.contexts.peek();
    }

    public Context parentContext() {
        if (this.contexts.size() < 2) {
            return null;
        }
        return (Context)this.contexts.get(this.contexts.size() - 2);
    }

    public Sequence currentSequence() {
        return this.sequences.get(this.currentSequence);
    }

    @Override
    public void visit(TaskAppNode taskApp) {
        String nextId;
        this.currentTaskAppId = nextId = this.nextId();
        Node node = new Node(nextId, taskApp.getName(), this.toMap(taskApp.getArguments()));
        this.addNode(node);
        if (taskApp.hasLabel()) {
            node.setLabel(taskApp.getLabelString());
            this.currentContext().addNodeWithLabel(taskApp.getLabelString(), node);
        }
        if (this.currentContext().isFlow) {
            List<String> danglingNodes;
            if (taskApp.hasLabel()) {
                Iterator<Context.TransitionTarget> iterator = this.currentContext().getTransitionTargets().iterator();
                while (iterator.hasNext()) {
                    Context.TransitionTarget tt = iterator.next();
                    if (!tt.label.equals(taskApp.getLabelString())) continue;
                    this.addLink(new Link(tt.nodeId, nextId, tt.onState));
                    iterator.remove();
                }
            }
            if ((danglingNodes = this.currentContext().getDanglingNodes()).size() == 0) {
                this.addLink(new Link(this.currentContext().startNodeId, nextId));
            } else {
                for (int i = 0; i < danglingNodes.size(); ++i) {
                    this.addLink(new Link(danglingNodes.get(i), nextId));
                }
            }
            this.currentContext().addDanglingNodes(true, nextId);
        } else if (this.currentContext().isSplit) {
            if (!this.currentContext().containingNode.hasLabel() || this.parentContext() == null || this.parentContext().isFlow) {
                // empty if block
            }
            this.addLink(new Link(this.currentContext().startNodeId, nextId));
            this.currentContext().addDanglingNodes(false, nextId);
        }
        this.existingNodesToReuse = this.currentContext().isFlow ? this.currentContext().extraNodes : new HashMap();
    }

    static class Context {
        final Map<String, Node> nodesWithLabels = new HashMap<String, Node>();
        public List<String> otherExits = new ArrayList<String>();
        public List<TransitionTarget> transitionTargets = new ArrayList<TransitionTarget>();
        public Map<String, Node> extraNodes = new HashMap<String, Node>();
        Map<String, Node> nodesSharedInFlow = new LinkedHashMap<String, Node>();
        LabelledTaskNode containingNode;
        boolean isFlow = false;
        boolean isSplit = false;
        private String startNodeId;
        private List<String> currentDanglingNodes = new ArrayList<String>();

        Context(boolean isFlow, boolean isSplit, String startNodeId, LabelledTaskNode split) {
            this.isFlow = isFlow;
            this.isSplit = isSplit;
            this.startNodeId = startNodeId;
            this.containingNode = split;
        }

        public void addDanglingNodes(boolean replaceExisting, String ... is) {
            if (replaceExisting) {
                this.currentDanglingNodes.clear();
            }
            for (String i : is) {
                this.currentDanglingNodes.add(i);
            }
        }

        public void addDanglingNodes(boolean replaceExisting, List<String> newDanglingNodes) {
            if (replaceExisting) {
                this.currentDanglingNodes.clear();
            }
            this.currentDanglingNodes.addAll(newDanglingNodes);
        }

        public List<String> getDanglingNodes() {
            return this.currentDanglingNodes;
        }

        public void clearDanglingNodes() {
            this.currentDanglingNodes.clear();
        }

        public void addTransitionTarget(String fromNodeId, String fromOnState, String targetLabel) {
            TransitionTarget tt = new TransitionTarget(fromNodeId, fromOnState, targetLabel);
            this.transitionTargets.add(tt);
        }

        public List<TransitionTarget> getTransitionTargets() {
            return this.transitionTargets;
        }

        public void addOtherExit(String nextId) {
            this.otherExits.add(nextId);
        }

        public Node getNodeLabeled(String label) {
            return this.nodesWithLabels.get(label);
        }

        public void addNodeWithLabel(String label, Node node) {
            this.nodesWithLabels.put(label, node);
        }

        static class TransitionTarget {
            String nodeId;
            String onState;
            String label;
            String lastNodeId;
            FlowNode flow;

            TransitionTarget(String fromNodeId, String fromOnState, String targetLabel) {
                this.nodeId = fromNodeId;
                this.onState = fromOnState;
                this.label = targetLabel;
            }

            public String toString() {
                StringBuilder s = new StringBuilder();
                s.append(this.nodeId).append(":").append(this.onState).append("->").append(this.label);
                return s.toString();
            }
        }
    }

    static class Sequence {
        final int sequenceNumber;
        final String label;
        final List<Node> nodes = new ArrayList<Node>();
        final List<Link> links = new ArrayList<Link>();
        final List<Context.TransitionTarget> outstandingTransitions = new ArrayList<Context.TransitionTarget>();
        final Map<FlowNode, Map<String, Node>> labeledNodesInEachFlow = new HashMap<FlowNode, Map<String, Node>>();
        FlowNode primaryFlow;

        Sequence(int sequenceNumber, String label, Node sequenceStartNode) {
            this.sequenceNumber = sequenceNumber;
            this.label = label;
            this.nodes.add(sequenceStartNode);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            for (Node n : this.nodes) {
                s.append("[").append(n.id).append(":").append(n.name).append("]");
            }
            for (Link l : this.links) {
                s.append("[" + (l.getTransitionName() == null ? "" : l.getTransitionName() + ":") + l.from + "-" + l.to + "]");
            }
            s.append("  transitions:").append(this.outstandingTransitions);
            s.append("   flowLabelsMap:").append(this.labeledNodesInEachFlow);
            return s.toString();
        }
    }
}

