/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import org.springframework.cloud.dataflow.core.dsl.AstNode;
import org.springframework.cloud.dataflow.core.dsl.DestinationNode;

public class SinkDestinationNode
extends AstNode {
    private final DestinationNode destinationNode;

    public SinkDestinationNode(DestinationNode destinationNode, int startPos) {
        super(startPos, destinationNode.endPos);
        this.destinationNode = destinationNode;
    }

    @Override
    public String stringify(boolean includePositionalInfo) {
        return ">" + this.destinationNode.stringify(includePositionalInfo);
    }

    public String toString() {
        return " > " + this.destinationNode.toString();
    }

    public DestinationNode getDestinationNode() {
        return this.destinationNode;
    }

    public String getDestinationName() {
        return this.destinationNode.getDestinationName();
    }

    public SinkDestinationNode copyOf() {
        return new SinkDestinationNode(this.destinationNode.copyOf(), this.startPos);
    }
}

