/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import org.springframework.cloud.dataflow.core.dsl.ArgumentNode;
import org.springframework.cloud.dataflow.core.dsl.AstNode;
import org.springframework.cloud.dataflow.core.dsl.DestinationNode;

public class SourceDestinationNode
extends AstNode {
    private final DestinationNode destinationNode;

    public SourceDestinationNode(DestinationNode destinationNode, int endPos) {
        super(destinationNode.startPos, endPos);
        this.destinationNode = destinationNode;
    }

    @Override
    public String stringify(boolean includePositionalInfo) {
        return this.destinationNode.stringify(includePositionalInfo) + ">";
    }

    public String toString() {
        return this.destinationNode.toString() + " > ";
    }

    public DestinationNode getDestinationNode() {
        return this.destinationNode;
    }

    public SourceDestinationNode copyOf() {
        return new SourceDestinationNode(this.destinationNode.copyOf(), this.endPos);
    }

    public String getDestinationName() {
        return this.destinationNode.getDestinationName();
    }

    public ArgumentNode[] getArguments() {
        return this.getDestinationNode().getArguments();
    }
}

