/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.Collections;
import java.util.List;
import org.springframework.cloud.dataflow.core.dsl.LabelledTaskNode;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;

public class SplitNode
extends LabelledTaskNode {
    private List<LabelledTaskNode> parallelTaskApps;

    SplitNode(int startpos, int endpos, List<LabelledTaskNode> parallelSequences) {
        super(startpos, endpos);
        this.parallelTaskApps = Collections.unmodifiableList(parallelSequences);
    }

    @Override
    public String stringify(boolean includePositionInfo) {
        StringBuilder s = new StringBuilder();
        s.append(TokenKind.LT.tokenChars);
        for (int i = 0; i < this.parallelTaskApps.size(); ++i) {
            LabelledTaskNode jn = this.parallelTaskApps.get(i);
            if (i > 0) {
                s.append(" ").append(TokenKind.DOUBLEPIPE.tokenChars).append(" ");
            }
            s.append(jn.stringify(includePositionInfo));
        }
        s.append(TokenKind.GT.tokenChars);
        return s.toString();
    }

    @Override
    public int getSeriesLength() {
        return this.parallelTaskApps.size();
    }

    @Override
    public LabelledTaskNode getSeriesElement(int index) {
        return this.parallelTaskApps.get(index);
    }

    @Override
    public List<LabelledTaskNode> getSeries() {
        return this.parallelTaskApps;
    }

    @Override
    public boolean isSplit() {
        return true;
    }

    public String toString() {
        return "[Split:" + this.stringify(true) + "]";
    }

    @Override
    public void accept(TaskVisitor visitor) {
        boolean cont = visitor.preVisit(this);
        if (!cont) {
            return;
        }
        visitor.visit(this);
        for (LabelledTaskNode labelledTaskNode : this.parallelTaskApps) {
            labelledTaskNode.accept(visitor);
        }
        visitor.postVisit(this);
    }
}

