/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.cloud.dataflow.core.dsl.AppNode;
import org.springframework.cloud.dataflow.core.dsl.AppParser;
import org.springframework.cloud.dataflow.core.dsl.ArgumentNode;
import org.springframework.cloud.dataflow.core.dsl.DSLMessage;
import org.springframework.cloud.dataflow.core.dsl.DestinationNode;
import org.springframework.cloud.dataflow.core.dsl.ParseException;
import org.springframework.cloud.dataflow.core.dsl.SinkDestinationNode;
import org.springframework.cloud.dataflow.core.dsl.SourceDestinationNode;
import org.springframework.cloud.dataflow.core.dsl.StreamNode;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;
import org.springframework.cloud.dataflow.core.dsl.Tokenizer;
import org.springframework.cloud.dataflow.core.dsl.Tokens;

public class StreamParser
extends AppParser {
    private final String name;
    private final String dsl;

    public StreamParser(String dsl) {
        this(null, dsl);
    }

    public StreamParser(String name, String dsl) {
        super(new Tokenizer().getTokens(dsl));
        this.name = name;
        this.dsl = dsl;
    }

    public StreamNode parse() {
        StreamNode ast = this.eatStream();
        if (ast.getName() != null && !this.isValidName(ast.getName())) {
            throw new ParseException(ast.getName(), 0, DSLMessage.ILLEGAL_STREAM_NAME, ast.getName());
        }
        if (this.name != null && !this.isValidName(this.name)) {
            throw new ParseException(this.name, 0, DSLMessage.ILLEGAL_STREAM_NAME, this.name);
        }
        LinkedHashMap<String, AppNode> alreadySeen = new LinkedHashMap<String, AppNode>();
        for (int m = 0; m < ast.getAppNodes().size(); ++m) {
            AppNode node = ast.getAppNodes().get(m);
            AppNode previous = alreadySeen.put(node.getLabelName(), node);
            if (previous == null) continue;
            String duplicate = node.getLabelName();
            int previousIndex = new ArrayList(alreadySeen.keySet()).indexOf(duplicate);
            throw new ParseException(this.dsl, node.startPos, DSLMessage.DUPLICATE_LABEL, duplicate, previous.getName(), previousIndex, node.getName(), m);
        }
        Tokens tokens = this.getTokens();
        if (tokens.hasNext()) {
            tokens.raiseException(tokens.peek().startPos, DSLMessage.MORE_INPUT, this.toString(tokens.next()));
        }
        return ast;
    }

    protected String eatStreamName() {
        Tokens tokens = this.getTokens();
        String streamName = null;
        if (tokens.lookAhead(1, TokenKind.EQUALS)) {
            if (tokens.peek(TokenKind.IDENTIFIER)) {
                streamName = tokens.eat((TokenKind)TokenKind.IDENTIFIER).data;
                tokens.next();
            } else {
                tokens.raiseException(tokens.peek().startPos, DSLMessage.ILLEGAL_STREAM_NAME, this.toString(tokens.peek()));
            }
        }
        return streamName;
    }

    protected StreamNode eatStream() {
        String streamName = this.eatStreamName();
        SourceDestinationNode sourceDestinationNode = this.eatSourceDestination();
        boolean bridge = false;
        if (sourceDestinationNode != null && this.looksLikeDestination() && this.noMorePipes()) {
            bridge = true;
        }
        Tokens tokens = this.getTokens();
        ArrayList<AppNode> appNodes = new ArrayList<AppNode>();
        if (bridge) {
            tokens.decrementPosition();
            AppNode bridgeAppNode = this.makeAppNode(null, "bridge", tokens.peek().startPos, tokens.peek().endPos, null);
            bridgeAppNode.setUnboundStreamApp(false);
            appNodes.add(bridgeAppNode);
        } else {
            appNodes.addAll(this.eatAppList(sourceDestinationNode != null));
        }
        SinkDestinationNode sinkDestinationNode = this.eatSinkDestination();
        if (tokens.hasNext()) {
            Token t = tokens.peek();
            DSLMessage errorMessage = DSLMessage.UNEXPECTED_DATA_AFTER_STREAMDEF;
            if (!appNodes.isEmpty() && sinkDestinationNode == null && tokens.getTokenStream().get(tokens.position() - 1).isKind(TokenKind.GT)) {
                errorMessage = DSLMessage.EXPECTED_DESTINATION_PREFIX;
            }
            tokens.raiseException(t.startPos, errorMessage, this.toString(t));
        }
        return this.makeStreamNode(tokens.getExpression(), streamName, appNodes, sourceDestinationNode, sinkDestinationNode);
    }

    protected boolean noMorePipes() {
        return this.noMorePipes(this.getTokens().position());
    }

    protected boolean noMorePipes(int position) {
        List<Token> tokenList = this.getTokens().getTokenStream();
        int tokenStreamLength = tokenList.size();
        while (position < tokenStreamLength) {
            if (tokenList.get(position++).getKind() != TokenKind.PIPE) continue;
            return false;
        }
        return true;
    }

    protected boolean looksLikeDestination() {
        return this.looksLikeDestination(this.getTokens().position());
    }

    protected boolean looksLikeDestination(int position) {
        Tokens tokens = this.getTokens();
        List<Token> tokenList = tokens.getTokenStream();
        return tokens.hasNext() && tokenList.get(position).getKind() == TokenKind.COLON && tokenList.get(position - 1).isKind(TokenKind.GT);
    }

    protected SourceDestinationNode eatSourceDestination() {
        Tokens tokens = this.getTokens();
        boolean gtBeforePipe = false;
        List<Token> tokenList = tokens.getTokenStream();
        for (int i = tokens.position(); i < tokenList.size(); ++i) {
            Token t = tokenList.get(i);
            if (t.getKind() == TokenKind.GT) {
                gtBeforePipe = true;
                break;
            }
            if (t.getKind() == TokenKind.PIPE) break;
        }
        if (!gtBeforePipe) {
            return null;
        }
        DestinationNode destinationNode = this.eatDestinationReference(false);
        if (destinationNode == null) {
            return null;
        }
        Token gt = tokens.eat(TokenKind.GT);
        return new SourceDestinationNode(destinationNode, gt.endPos);
    }

    protected SinkDestinationNode eatSinkDestination() {
        Tokens tokens = this.getTokens();
        SinkDestinationNode SinkDestinationNode2 = null;
        if (tokens.peek(TokenKind.GT)) {
            Token gt = tokens.eat(TokenKind.GT);
            DestinationNode destinationNode = this.eatDestinationReference(false);
            if (destinationNode == null) {
                return null;
            }
            SinkDestinationNode2 = new SinkDestinationNode(destinationNode, gt.startPos);
        }
        return SinkDestinationNode2;
    }

    protected Token peekDestinationComponentToken() {
        Token t = this.getTokens().peek();
        if (t == null) {
            return null;
        }
        if (t.kind == TokenKind.IDENTIFIER || t.kind == TokenKind.STAR || t.kind == TokenKind.SLASH || t.kind == TokenKind.HASH) {
            return t;
        }
        return null;
    }

    protected String getTokenData(Token token) {
        return token.kind.hasPayload() ? token.data : new String(token.kind.getTokenChars());
    }

    protected DestinationNode eatDestinationReference(boolean canDefault) {
        Tokens tokens = this.getTokens();
        Token firstToken = tokens.next();
        if (!firstToken.isKind(TokenKind.COLON)) {
            tokens.decrementPosition();
            return null;
        }
        StringBuilder destinationName = new StringBuilder();
        Token token = this.peekDestinationComponentToken();
        if (token == null) {
            if (tokens.peek() == null) {
                tokens.raiseException(firstToken.startPos, DSLMessage.OOD, new Object[0]);
            } else {
                tokens.raiseException(tokens.peek().startPos, DSLMessage.UNEXPECTED_DATA_IN_DESTINATION_NAME, this.getTokenData(tokens.peek()));
            }
        }
        int startpos = token.startPos;
        destinationName.append(this.getTokenData(token));
        tokens.next();
        while (tokens.isNextAdjacent() && (token = this.peekDestinationComponentToken()) != null) {
            destinationName.append(this.getTokenData(token));
            tokens.next();
        }
        while (tokens.peek(TokenKind.DOT)) {
            if (!tokens.isNextAdjacent()) {
                tokens.raiseException(tokens.peek().startPos, DSLMessage.NO_WHITESPACE_IN_DESTINATION_DEFINITION, new Object[0]);
            }
            tokens.next();
            destinationName.append(TokenKind.DOT.getTokenChars());
            if (!tokens.isNextAdjacent()) {
                tokens.raiseException(tokens.peek().startPos, DSLMessage.NO_WHITESPACE_IN_DESTINATION_DEFINITION, new Object[0]);
            }
            while (tokens.isNextAdjacent() && (token = this.peekDestinationComponentToken()) != null) {
                destinationName.append(this.getTokenData(token));
                tokens.next();
            }
        }
        int endPos = token.endPos;
        ArgumentNode[] argumentNodes = this.eatAppArgs();
        return this.makeDestinationNode(startpos, endPos, destinationName.toString(), argumentNodes);
    }

    protected List<AppNode> eatAppList(boolean preceedingSourceChannelSpecified) {
        boolean isFollowedBySinkChannel;
        Tokens tokens = this.getTokens();
        ArrayList<AppNode> appNodes = new ArrayList<AppNode>();
        int usedListDelimiter = -1;
        int usedStreamDelimiter = -1;
        appNodes.add(this.eatApp());
        while (tokens.hasNext()) {
            Token t = tokens.peek();
            if (t.kind == TokenKind.PIPE) {
                if (usedListDelimiter >= 0) {
                    tokens.raiseException(t.startPos, DSLMessage.DONT_MIX_PIPE_AND_DOUBLEPIPE, new Object[0]);
                }
                usedStreamDelimiter = t.startPos;
                tokens.next();
                appNodes.add(this.eatApp());
                continue;
            }
            if (t.kind != TokenKind.DOUBLEPIPE) break;
            if (preceedingSourceChannelSpecified) {
                tokens.raiseException(t.startPos, DSLMessage.DONT_USE_DOUBLEPIPE_WITH_CHANNELS, new Object[0]);
            }
            if (usedStreamDelimiter >= 0) {
                tokens.raiseException(t.startPos, DSLMessage.DONT_MIX_PIPE_AND_DOUBLEPIPE, new Object[0]);
            }
            usedListDelimiter = t.startPos;
            tokens.next();
            appNodes.add(this.eatApp());
        }
        if ((isFollowedBySinkChannel = tokens.peek(TokenKind.GT)) && usedListDelimiter >= 0) {
            tokens.raiseException(usedListDelimiter, DSLMessage.DONT_USE_DOUBLEPIPE_WITH_CHANNELS, new Object[0]);
        }
        for (AppNode appNode : appNodes) {
            appNode.setUnboundStreamApp(!preceedingSourceChannelSpecified && !isFollowedBySinkChannel && usedStreamDelimiter < 0);
        }
        return appNodes;
    }

    public String toString() {
        Tokens tokens = this.getTokens();
        return String.valueOf(tokens.getTokenStream()) + "\ntokenStreamPointer=" + tokens.position() + "\n";
    }

    protected DestinationNode makeDestinationNode(int startpos, int endPos, String destinationName, ArgumentNode[] argumentNodes) {
        return new DestinationNode(startpos, endPos, destinationName, argumentNodes);
    }

    protected StreamNode makeStreamNode(String streamText, String streamName, List<AppNode> appNodes, SourceDestinationNode sourceDestinationNode, SinkDestinationNode sinkDestinationNode) {
        return new StreamNode(streamText, streamName, appNodes, sourceDestinationNode, sinkDestinationNode);
    }
}

