/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import java.util.Map;
import org.springframework.cloud.dataflow.core.dsl.TaskAppNode;
import org.springframework.cloud.dataflow.core.dsl.TaskNode;
import org.springframework.util.Assert;

public class TaskApp {
    private String taskDefinitionName;
    private String name;
    private Map<String, String> arguments;
    private String label;

    TaskApp(String taskDefinitionName, TaskAppNode taskAppNode) {
        Assert.notNull((Object)taskAppNode, (String)"taskAppNode not expected to be null");
        this.taskDefinitionName = taskDefinitionName;
        this.name = taskAppNode.getName();
        this.arguments = taskAppNode.getArgumentsAsMap();
        this.label = taskAppNode.getLabelString();
    }

    public String getTaskName() {
        return this.taskDefinitionName;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.label != null) {
            s.append(this.label).append(": ");
        }
        s.append(this.name);
        if (this.arguments.size() != 0) {
            s.append(" ");
            for (Map.Entry<String, String> argument : this.arguments.entrySet()) {
                s.append("--").append(argument.getKey()).append("=").append(argument.getValue());
            }
        }
        return s.toString();
    }

    public String getExecutableDSLName() {
        StringBuilder s = new StringBuilder();
        s.append(TaskNode.getTaskPrefix(this.taskDefinitionName));
        s.append(this.label == null ? this.name : this.label);
        return s.toString();
    }
}

