/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import org.springframework.cloud.dataflow.core.dsl.TokenKind;

public class Token {
    public TokenKind kind;
    public String data;
    public int startPos;
    public int endPos;

    Token(TokenKind tokenKind, int startPos, int endPos) {
        this.kind = tokenKind;
        this.startPos = startPos;
        this.endPos = endPos;
    }

    Token(TokenKind tokenKind, char[] tokenData, int pos, int endPos) {
        this(tokenKind, pos, endPos);
        this.data = new String((char[])tokenData.clone());
    }

    public TokenKind getKind() {
        return this.kind;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[").append(this.kind.toString());
        if (this.kind.hasPayload()) {
            s.append(":").append(this.data);
        }
        s.append("]");
        s.append("(").append(this.startPos).append(",").append(this.endPos).append(")");
        return s.toString();
    }

    public boolean isIdentifier() {
        return this.kind == TokenKind.IDENTIFIER;
    }

    public String stringValue() {
        return this.data;
    }

    public int hashCode() {
        return this.kind.ordinal() * 37 + (this.startPos + this.endPos) * 37 + (this.kind.hasPayload() ? this.data.hashCode() : 0);
    }

    public boolean equals(Object o) {
        boolean basicMatch;
        if (!(o instanceof Token)) {
            return false;
        }
        Token token = (Token)o;
        boolean bl = basicMatch = this.kind == token.kind && this.startPos == token.startPos && this.endPos == token.endPos;
        if (!basicMatch) {
            return false;
        }
        return !this.kind.hasPayload() || this.data.equals(token.data);
    }

    public boolean isKind(TokenKind desiredKind) {
        return this.kind == desiredKind;
    }
}

