/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

public enum TokenKind {
    IDENTIFIER,
    DOUBLE_MINUS("--"),
    EQUALS("="),
    AND("&"),
    ANDAND("&&"),
    DOUBLEPIPE("||"),
    ARROW("->"),
    PIPE("|"),
    OPEN_PAREN("("),
    CLOSE_PAREN(")"),
    NEWLINE("\n"),
    STAR("*"),
    COLON(":"),
    GT(">"),
    LT("<"),
    SEMICOLON(";"),
    REFERENCE("@"),
    DOT("."),
    LITERAL_STRING,
    SLASH("/"),
    HASH("#");

    char[] tokenChars;
    private boolean hasPayload;

    private TokenKind(String tokenString) {
        this.tokenChars = tokenString.toCharArray();
        this.hasPayload = this.tokenChars.length == 0;
    }

    private TokenKind() {
        this("");
    }

    public String toString() {
        return this.name() + (this.tokenChars.length != 0 ? "(" + new String(this.tokenChars) + ")" : "");
    }

    public boolean hasPayload() {
        return this.hasPayload;
    }

    public int getLength() {
        return this.tokenChars.length;
    }

    public char[] getTokenChars() {
        return this.tokenChars;
    }
}

