/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import org.springframework.cloud.dataflow.core.dsl.AbstractTokenizer;
import org.springframework.cloud.dataflow.core.dsl.DSLMessage;
import org.springframework.cloud.dataflow.core.dsl.ParseException;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;

public class Tokenizer
extends AbstractTokenizer {
    @Override
    protected void process() {
        boolean justProcessedEquals = false;
        block21: while (this.pos < this.max) {
            char ch = this.toProcess[this.pos];
            if (justProcessedEquals) {
                if (!this.isWhitespace(ch) && ch != '\u0000') {
                    if (this.isArgValueIdentifierTerminator(ch, false)) {
                        this.raiseException(DSLMessage.EXPECTED_ARGUMENT_VALUE, Character.valueOf(ch));
                    }
                    this.lexArgValueIdentifier();
                }
                justProcessedEquals = false;
                continue;
            }
            if (this.isAlphabetic(ch) || this.isDigit(ch) || ch == '_') {
                this.lexIdentifier();
                continue;
            }
            switch (ch) {
                case '-': {
                    if (!this.isTwoCharToken(TokenKind.DOUBLE_MINUS)) {
                        throw new ParseException(this.expressionString, this.pos, DSLMessage.MISSING_CHARACTER, "-");
                    }
                    this.pushPairToken(TokenKind.DOUBLE_MINUS);
                    continue block21;
                }
                case '=': {
                    justProcessedEquals = true;
                    this.pushCharToken(TokenKind.EQUALS);
                    continue block21;
                }
                case '&': {
                    this.pushCharToken(TokenKind.AND);
                    continue block21;
                }
                case '|': {
                    if (this.isTwoCharToken(TokenKind.DOUBLEPIPE)) {
                        this.pushPairToken(TokenKind.DOUBLEPIPE);
                        continue block21;
                    }
                    this.pushCharToken(TokenKind.PIPE);
                    continue block21;
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    ++this.pos;
                    continue block21;
                }
                case '\n': {
                    this.pushCharToken(TokenKind.NEWLINE);
                    continue block21;
                }
                case '.': {
                    this.pushCharToken(TokenKind.DOT);
                    continue block21;
                }
                case '<': {
                    this.pushCharToken(TokenKind.LT);
                    continue block21;
                }
                case '>': {
                    this.pushCharToken(TokenKind.GT);
                    continue block21;
                }
                case ':': {
                    this.pushCharToken(TokenKind.COLON);
                    continue block21;
                }
                case '/': {
                    this.pushCharToken(TokenKind.SLASH);
                    continue block21;
                }
                case '#': {
                    this.pushCharToken(TokenKind.HASH);
                    continue block21;
                }
                case '*': {
                    this.pushCharToken(TokenKind.STAR);
                    continue block21;
                }
                case ';': {
                    this.pushCharToken(TokenKind.SEMICOLON);
                    continue block21;
                }
                case '\'': {
                    this.lexQuotedStringLiteral();
                    continue block21;
                }
                case '\"': {
                    this.lexDoubleQuotedStringLiteral();
                    continue block21;
                }
                case '@': {
                    this.pushCharToken(TokenKind.REFERENCE);
                    continue block21;
                }
                case '\u0000': {
                    ++this.pos;
                    continue block21;
                }
                case '\\': {
                    throw new ParseException(this.expressionString, this.pos, DSLMessage.UNEXPECTED_ESCAPE_CHAR, new Object[0]);
                }
            }
            throw new ParseException(this.expressionString, this.pos, DSLMessage.UNEXPECTED_DATA, Character.valueOf(ch).toString());
        }
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.expressionString).append("\n");
        for (int i = 0; i < this.pos; ++i) {
            s.append(" ");
        }
        s.append("^\n");
        s.append(this.tokens).append("\n");
        return s.toString();
    }
}

