/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl;

import org.springframework.cloud.dataflow.core.dsl.AstNode;
import org.springframework.cloud.dataflow.core.dsl.TaskAppNode;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;
import org.springframework.cloud.dataflow.core.dsl.Token;
import org.springframework.cloud.dataflow.core.dsl.TokenKind;

public class TransitionNode
extends AstNode {
    public static final String FAIL = "$FAIL";
    public static final String END = "$END";
    private Token statusToken;
    private String status;
    private boolean isExitCodeCheck;
    private Token targetLabel;
    private TaskAppNode targetApp;

    private TransitionNode(Token statusToken, int endPos) {
        super(statusToken.startPos, endPos);
        this.statusToken = statusToken;
        if (statusToken.isKind(TokenKind.LITERAL_STRING)) {
            this.isExitCodeCheck = false;
            String quotesUsed = statusToken.data.substring(0, 1);
            this.status = statusToken.data.substring(1, statusToken.data.length() - 1).replace(quotesUsed + quotesUsed, quotesUsed);
        } else {
            this.isExitCodeCheck = true;
            this.status = statusToken.isKind(TokenKind.STAR) ? "*" : this.statusToken.stringValue();
        }
    }

    static TransitionNode toLabelReference(Token transitionOnToken, Token labelReference) {
        TransitionNode t = new TransitionNode(transitionOnToken, labelReference.endPos);
        t.targetLabel = labelReference;
        return t;
    }

    static TransitionNode toAnotherTask(Token transitionOnToken, TaskAppNode targetApp) {
        TransitionNode t = new TransitionNode(transitionOnToken, targetApp.endPos);
        t.targetApp = targetApp;
        return t;
    }

    @Override
    public String stringify(boolean includePositionInfo) {
        StringBuilder s = new StringBuilder();
        s.append(this.statusToken.getKind() == TokenKind.STAR ? "*" : this.statusToken.stringValue()).append("->");
        if (this.targetLabel != null) {
            s.append(":").append(this.targetLabel.stringValue());
        } else {
            s.append(this.targetApp.stringify(includePositionInfo));
        }
        return s.toString();
    }

    public String getStatusToCheck() {
        return this.status;
    }

    public String getStatusToCheckInDSLForm() {
        if (this.isExitCodeCheck) {
            return this.status;
        }
        return "'" + this.status + "'";
    }

    public boolean isTargetApp() {
        return this.targetApp != null;
    }

    public String getTargetLabel() {
        return this.targetLabel == null ? null : this.targetLabel.stringValue();
    }

    public TaskAppNode getTargetApp() {
        return this.targetApp;
    }

    public boolean isSpecialTransition() {
        return this.isFailTransition() || this.isEndTransition();
    }

    public boolean isFailTransition() {
        return this.getTargetApp().getName().equals(FAIL);
    }

    public boolean isEndTransition() {
        return this.getTargetApp().getName().equals(END);
    }

    public boolean isExitCodeCheck() {
        return this.isExitCodeCheck;
    }

    public String getTargetDslText() {
        if (this.targetLabel == null) {
            return this.targetApp.toDslText();
        }
        return ":" + this.targetLabel.stringValue();
    }

    public void accept(TaskVisitor visitor) {
        boolean cont = visitor.preVisit(this);
        if (!cont) {
            return;
        }
        visitor.visit(this);
        visitor.postVisit(this);
    }
}

