/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl.graph;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.dataflow.core.dsl.graph.Link;
import org.springframework.cloud.dataflow.core.dsl.graph.Node;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Graph {
    public List<Node> nodes;
    public List<Link> links;

    Graph() {
        this.nodes = new ArrayList<Node>();
        this.links = new ArrayList<Link>();
    }

    public Graph(List<Node> nodes, List<Link> links) {
        this.nodes = nodes;
        this.links = links;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public String toString() {
        return "Graph:  nodes=#" + this.nodes.size() + "  links=#" + this.links.size() + "\n" + this.nodes + "\n" + this.links;
    }

    public String toVerboseString() {
        StringBuilder s = new StringBuilder();
        for (Node n : this.nodes) {
            s.append("[").append(n.id).append(":");
            if (n.getLabel() != null) {
                s.append(n.getLabel()).append(":");
            }
            s.append(n.name);
            if (n.properties != null) {
                for (Map.Entry<String, String> property : n.properties.entrySet()) {
                    s.append(":").append(property.getKey()).append("=").append(property.getValue());
                }
            }
            s.append("]");
        }
        for (Link l : this.links) {
            s.append("[" + (l.getTransitionName() == null ? "" : l.getTransitionName() + ":") + l.from + "-" + l.to + "]");
        }
        return s.toString();
    }

    public String toDSLText() {
        StringBuilder graphText = new StringBuilder();
        ArrayList<Node> unvisitedNodes = new ArrayList<Node>();
        ArrayList<Link> unfollowedLinks = new ArrayList<Link>();
        unvisitedNodes.addAll(this.nodes);
        unfollowedLinks.addAll(this.links);
        Node start = this.findNodeByName("START");
        unvisitedNodes.remove(start);
        Node end = this.findNodeByName("END");
        unvisitedNodes.remove(end);
        Node fail = this.findNodeByName("FAIL");
        if (fail != null) {
            unvisitedNodes.remove(fail);
        }
        if (start == null || end == null) {
            throw new IllegalStateException("Graph is malformed - problems finding START and END nodes");
        }
        List<Link> toFollow = this.findLinksFrom(start, false);
        this.followLinks(graphText, toFollow, null, unvisitedNodes, unfollowedLinks, false);
        if (unvisitedNodes.size() != 0) {
            for (int loopCount = 0; unvisitedNodes.size() != 0 && loopCount < 10000; ++loopCount) {
                Node nextHead = this.findAHead(unvisitedNodes, unfollowedLinks);
                unvisitedNodes.remove(nextHead);
                toFollow = this.findLinksFrom(nextHead, false);
                if (toFollow.size() == 0) continue;
                graphText.append(" && ");
                this.printNode(graphText, nextHead, unvisitedNodes);
                this.followLinks(graphText, toFollow, null, unvisitedNodes, unfollowedLinks, false);
            }
        }
        return graphText.toString();
    }

    private Node findAHead(List<Node> unvisitedNodes, List<Link> unvisitedLinks) {
        if (unvisitedNodes.size() == 0) {
            return null;
        }
        Node candidate = unvisitedNodes.get(0);
        boolean changedCandidate = true;
        while (changedCandidate) {
            changedCandidate = false;
            for (Link link : unvisitedLinks) {
                if (link.to != candidate.id) continue;
                changedCandidate = true;
                candidate = this.findNodeById(link.from);
            }
        }
        return candidate;
    }

    private void followLinks(StringBuilder graphText, List<Link> toFollow, Node nodeToTerminateFollow, List<Node> unvisitedNodes, List<Link> unfollowedLinks, boolean inNestedSplit) {
        while (toFollow.size() != 0) {
            if (toFollow.size() > 1) {
                if (!inNestedSplit && graphText.length() != 0) {
                    graphText.append(" && ");
                }
                graphText.append("<");
                Node endOfSplit = this.findEndOfSplit(toFollow);
                if (toFollow.size() > 2) {
                    Map<Node, List<Link>> nestedSplits = this.findNestedSplits(toFollow, endOfSplit);
                    int i = 0;
                    for (Map.Entry<Node, List<Link>> nestedSplit : nestedSplits.entrySet()) {
                        Node endOfNestedSplit = nestedSplit.getKey();
                        List<Link> nestedSplitLinks = nestedSplit.getValue();
                        this.followLinks(graphText, nestedSplitLinks, endOfNestedSplit, unvisitedNodes, unfollowedLinks, true);
                        toFollow.removeAll(nestedSplitLinks);
                        graphText.append(" && ");
                        this.followNode(graphText, endOfNestedSplit, endOfSplit, unvisitedNodes, unfollowedLinks);
                        if (++i >= nestedSplits.size()) continue;
                        graphText.append(" || ");
                    }
                    if (!toFollow.isEmpty() && !nestedSplits.isEmpty()) {
                        graphText.append(" || ");
                    }
                }
                for (int i = 0; i < toFollow.size(); ++i) {
                    if (i > 0) {
                        graphText.append(" || ");
                    }
                    Link l = toFollow.get(i);
                    this.followLink(graphText, l, endOfSplit, unvisitedNodes, unfollowedLinks);
                }
                graphText.append(">");
                if (endOfSplit == null || endOfSplit.isEnd() || endOfSplit == nodeToTerminateFollow) break;
                unvisitedNodes.remove(endOfSplit);
                if (!endOfSplit.isSync()) {
                    graphText.append(" && ");
                    this.printNode(graphText, endOfSplit, unvisitedNodes);
                    List<Link> transitionalLinks = this.findLinksFrom(endOfSplit, false);
                    this.printTransitions(graphText, unvisitedNodes, unfollowedLinks, transitionalLinks, null);
                }
                toFollow = this.findLinksFromWithoutTransitions(endOfSplit, false);
                continue;
            }
            if (toFollow.size() != 1) continue;
            Link linkToFollow = toFollow.get(0);
            Node linkToFollowTarget = this.findNodeById(linkToFollow.to);
            if (linkToFollowTarget == nodeToTerminateFollow) break;
            if (graphText.length() != 0) {
                graphText.append(" && ");
            }
            this.followLink(graphText, linkToFollow, nodeToTerminateFollow, unvisitedNodes, unfollowedLinks);
            break;
        }
    }

    private List<Link> findSubsetOfLinksThatReachNode(List<Link> links, Link linkToIgnore, Node node) {
        ArrayList<Link> result = null;
        for (Link link : links) {
            if (link == linkToIgnore || !this.foundInChain(link, node)) continue;
            if (result == null) {
                result = new ArrayList<Link>();
            }
            result.add(link);
        }
        if (result != null) {
            result.add(linkToIgnore);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Node, List<Link>> findNestedSplits(List<Link> toFollow, Node end) {
        LinkedHashMap<Node, List<Link>> nestedSplits = new LinkedHashMap<Node, List<Link>>();
        for (Link link : toFollow) {
            void var6_6;
            Node node = this.findNodeById(link.to);
            while (var6_6 != null && var6_6 != end) {
                List<Link> links;
                List<Link> commonLinks = this.findSubsetOfLinksThatReachNode(toFollow, link, (Node)var6_6);
                if (commonLinks != null) {
                    boolean insertThisOne = true;
                    Node forRemoval = null;
                    for (Map.Entry subsplit : nestedSplits.entrySet()) {
                        if (!this.equalLinkLists((List)subsplit.getValue(), commonLinks)) continue;
                        if (this.isSuccessor((Node)subsplit.getKey(), (Node)var6_6)) {
                            insertThisOne = false;
                            continue;
                        }
                        forRemoval = (Node)subsplit.getKey();
                    }
                    if (insertThisOne) {
                        if (forRemoval != null) {
                            nestedSplits.remove(forRemoval);
                        }
                        nestedSplits.put((Node)var6_6, commonLinks);
                    }
                }
                if ((links = this.findLinksFrom((Node)var6_6, true)).size() == 0) {
                    Object var6_8 = null;
                    continue;
                }
                if (links.size() == 1) {
                    Node node2 = this.findNodeById(links.get((int)0).to);
                    continue;
                }
                if (this.countLinksWithoutTransitions(links) == 0 || this.countLinksWithoutTransitions(links) == 1) {
                    Node node3 = this.findNodeById(links.get((int)0).to);
                    continue;
                }
                while (this.countLinksWithoutTransitions(links) > 1) {
                    Node node4 = this.findEndOfSplit(links);
                    links = this.findLinksFrom(node4, true);
                }
            }
        }
        ArrayList toSort = new ArrayList(nestedSplits.entrySet());
        Collections.sort(toSort, new NestedSplitComparator());
        nestedSplits = new LinkedHashMap();
        for (Map.Entry entry : toSort) {
            nestedSplits.put((Node)entry.getKey(), (List<Link>)entry.getValue());
        }
        return nestedSplits;
    }

    private boolean equalLinkLists(List<Link> list1, List<Link> list2) {
        return list1.containsAll(list2) && list2.containsAll(list1);
    }

    private boolean isSuccessor(Node a, Node b) {
        for (Link link : this.findLinksFrom(a, true)) {
            if (!this.foundInChain(link, b)) continue;
            return true;
        }
        return false;
    }

    private Node findEndOfSplit(List<Link> toFollow) {
        if (toFollow.size() == 0) {
            return null;
        }
        if (toFollow.size() == 1) {
            return this.findNodeById(toFollow.get((int)0).to);
        }
        Link link = toFollow.get(0);
        Node nextCandidate = this.findNodeById(link.to);
        while (nextCandidate != null) {
            boolean allLinksLeadToTheCandidate = true;
            for (int l = 1; l < toFollow.size(); ++l) {
                if (this.foundInChain(toFollow.get(l), nextCandidate)) continue;
                allLinksLeadToTheCandidate = false;
                break;
            }
            if (allLinksLeadToTheCandidate) {
                return nextCandidate;
            }
            List<Link> links = this.findLinksFrom(nextCandidate, true);
            if (links.size() == 0) {
                nextCandidate = null;
                continue;
            }
            if (links.size() == 1) {
                nextCandidate = this.findNodeById(links.get((int)0).to);
                continue;
            }
            if (this.countLinksWithoutTransitions(links) == 0 || this.countLinksWithoutTransitions(links) == 1) {
                nextCandidate = this.findNodeById(links.get((int)0).to);
                continue;
            }
            while (this.countLinksWithoutTransitions(links) > 1) {
                nextCandidate = this.findEndOfSplit(links);
                links = this.findLinksFrom(nextCandidate, true);
            }
        }
        throw new IllegalStateException("Unable to find end of split");
    }

    private boolean foundInChain(Link link, Node candidate) {
        String targetId = link.to;
        Node targetNode = this.findNodeById(targetId);
        if (targetNode == candidate) {
            return true;
        }
        List<Link> outboundLinks = this.findLinksFrom(targetNode, true);
        for (Link lnk : outboundLinks) {
            if (!this.foundInChain(lnk, candidate)) continue;
            return true;
        }
        return false;
    }

    private int countLinksWithoutTransitions(List<Link> links) {
        int count = 0;
        for (Link link : links) {
            if (link.hasTransitionSet()) continue;
            ++count;
        }
        return count;
    }

    private void printNode(StringBuilder graphText, Node node, List<Node> unvisitedNodes) {
        unvisitedNodes.remove(node);
        String nameInDSL = node.name;
        if (node.getLabel() != null) {
            graphText.append(node.getLabel()).append(": ");
        }
        graphText.append(nameInDSL);
        this.printNodeProperties(graphText, node);
    }

    private void printNodeProperties(StringBuilder graphText, Node node) {
        if (node.properties != null) {
            for (Map.Entry<String, String> entry : node.properties.entrySet()) {
                graphText.append(" ");
                String propertyValue = entry.getValue();
                if (propertyValue.contains(" ") && !propertyValue.startsWith("'")) {
                    propertyValue = "'" + propertyValue + "'";
                }
                graphText.append("--").append(entry.getKey()).append("=").append(propertyValue);
            }
        }
    }

    private void followNode(StringBuilder graphText, Node node, Node nodeToFinishFollowingAt, List<Node> unvisitedNodes, List<Link> unfollowedLinks) {
        List<Link> toFollow = this.findLinksFrom(node, false);
        boolean singleSplitNecessary = false;
        Node commonTarget = null;
        if (toFollow.size() > 1 && this.allTransitionsButOne(toFollow)) {
            try {
                commonTarget = this.findEndOfSplit(this.sortNotTransitionLinkFirst(toFollow));
                singleSplitNecessary = commonTarget != null && !commonTarget.name.equals("END") && (nodeToFinishFollowingAt == null || !nodeToFinishFollowingAt.equals(commonTarget));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (singleSplitNecessary) {
            graphText.append("<");
            this.printNode(graphText, node, unvisitedNodes);
            this.printTransitions(graphText, unvisitedNodes, unfollowedLinks, toFollow, commonTarget);
            graphText.append(">");
        } else {
            this.printNode(graphText, node, unvisitedNodes);
            this.printTransitions(graphText, unvisitedNodes, unfollowedLinks, toFollow, nodeToFinishFollowingAt);
        }
        this.followLinks(graphText, toFollow, nodeToFinishFollowingAt, unvisitedNodes, unfollowedLinks, false);
    }

    List<Link> sortNotTransitionLinkFirst(List<Link> links) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link l : links) {
            if (l.hasTransitionSet()) {
                result.add(0, l);
                continue;
            }
            result.add(l);
        }
        return result;
    }

    private boolean allTransitionsButOne(List<Link> links) {
        int transitionCount = 0;
        for (Link l : links) {
            if (!l.hasTransitionSet()) continue;
            ++transitionCount;
        }
        return links.size() - transitionCount == 1;
    }

    private void followLink(StringBuilder graphText, Link link, Node nodeToFinishFollowingAt, List<Node> unvisitedNodes, List<Link> unfollowedLinks) {
        unfollowedLinks.remove(link);
        this.followNode(graphText, this.findNodeById(link.to), nodeToFinishFollowingAt, unvisitedNodes, unfollowedLinks);
    }

    private void printTransitions(StringBuilder graphText, List<Node> unvisitedNodes, List<Link> unfollowedLinks, List<Link> toFollow, Node nodeToFinishFollowingAt) {
        Iterator<Link> iterator = toFollow.iterator();
        while (iterator.hasNext()) {
            Link l = iterator.next();
            if (!l.hasTransitionSet()) continue;
            String transitionName = l.getTransitionName();
            boolean isStatusText = true;
            try {
                Integer.parseInt(transitionName);
                isStatusText = false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (isStatusText && !transitionName.startsWith("'")) {
                transitionName = "'" + transitionName + "'";
            }
            Node transitionTarget = this.findNodeById(l.to);
            String transitionTargetName = transitionTarget.name;
            if (transitionTargetName.equals("FAIL")) {
                transitionTargetName = "$FAIL";
            } else if (transitionTargetName.equals("END")) {
                transitionTargetName = "$END";
            } else if (transitionTarget.getLabel() != null) {
                transitionTargetName = transitionTarget.getLabel() + ": " + transitionTargetName;
            }
            graphText.append(" ").append(transitionName).append("->").append(transitionTargetName);
            this.printNodeProperties(graphText, transitionTarget);
            unfollowedLinks.remove(l);
            List<Link> linksFromTheTransitionTarget = this.findLinksFrom(transitionTarget, false);
            if (linksFromTheTransitionTarget.isEmpty() || this.allLinksTarget(linksFromTheTransitionTarget, nodeToFinishFollowingAt)) {
                unvisitedNodes.remove(transitionTarget);
            }
            iterator.remove();
        }
    }

    private boolean allLinksTarget(List<Link> linksFromTheTransitionTarget, Node nodeToFinishFollowingAt) {
        if (nodeToFinishFollowingAt == null) {
            return false;
        }
        for (Link link : linksFromTheTransitionTarget) {
            if (link.to.equals(nodeToFinishFollowingAt.id)) continue;
            return false;
        }
        return true;
    }

    private Node findNodeById(String id) {
        for (Node n : this.nodes) {
            if (!n.id.equals(id)) continue;
            return n;
        }
        return null;
    }

    private Node findNodeByName(String name) {
        for (Node n : this.nodes) {
            if (!n.name.equals(name)) continue;
            return n;
        }
        return null;
    }

    private List<Link> findLinksFromWithoutTransitions(Node n, boolean includeThoseLeadingToEnd) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.from.equals(n.id) || (link.hasTransitionSet() || !includeThoseLeadingToEnd && this.findNodeById((String)link.to).name.equals("END")) && (!link.hasTransitionSet() || !link.getTransitionName().equals("'*'"))) continue;
            result.add(link);
        }
        return result;
    }

    private boolean hasNoProperties(Link link) {
        return link.properties == null || link.properties.size() == 0;
    }

    private List<Link> findLinksFrom(Node n, boolean includeThoseLeadingToEnd) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.from.equals(n.id) || !includeThoseLeadingToEnd && this.findNodeById((String)link.to).name.equals("END") && this.hasNoProperties(link)) continue;
            result.add(link);
        }
        return result;
    }

    class NestedSplitComparator
    implements Comparator<Map.Entry<Node, List<Link>>> {
        NestedSplitComparator() {
        }

        @Override
        public int compare(Map.Entry<Node, List<Link>> splitA, Map.Entry<Node, List<Link>> splitB) {
            Node endOfB;
            Node endOfA = splitA.getKey();
            if (endOfA == (endOfB = splitB.getKey())) {
                return 0;
            }
            if (Graph.this.isSuccessor(endOfA, endOfB)) {
                return -1;
            }
            return 1;
        }
    }
}

