/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl.graph;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Link {
    public static final String PROPERTY_TRANSITION_NAME = "transitionName";
    public String from;
    public String to;
    public Map<String, String> properties = null;

    Link() {
    }

    public Link(String sourceId, String targetId) {
        this.from = sourceId;
        this.to = targetId;
    }

    public Link(String sourceId, String targetId, String transitionName) {
        this.from = sourceId;
        this.to = targetId;
        this.properties = new HashMap<String, String>();
        this.properties.put(PROPERTY_TRANSITION_NAME, transitionName);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Link[from=").append(this.from).append(",to=").append(this.to);
        if (this.properties != null) {
            s.append(",properties=").append(this.properties);
        }
        s.append("]");
        return s.toString();
    }

    public boolean hasTransitionSet() {
        return this.properties != null && this.properties.containsKey(PROPERTY_TRANSITION_NAME);
    }

    @JsonIgnore
    public String getTransitionName() {
        return this.properties != null ? this.properties.get(PROPERTY_TRANSITION_NAME) : null;
    }

    public void updateFrom(String newFrom) {
        this.from = newFrom;
    }

    public void updateTo(String newTo) {
        this.to = newTo;
    }
}

