/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.core.dsl.graph;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Node {
    public static final String METADATA_LABEL = "label";
    public String id;
    public String name;
    public Map<String, String> properties;
    public Map<String, String> metadata;

    Node() {
    }

    public Node(String id, String name) {
        this.id = id;
        this.name = name;
        this.properties = null;
    }

    public Node(String id, String name, Map<String, String> properties) {
        this.id = id;
        this.name = name;
        this.properties = properties;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Node[id=").append(this.id).append(",name=").append(this.name);
        if (this.properties != null) {
            s.append(",properties=").append(this.properties);
        }
        s.append("]");
        return s.toString();
    }

    @JsonIgnore
    public boolean isStart() {
        return this.name.equals("START");
    }

    @JsonIgnore
    public boolean isEnd() {
        return this.name.equals("END");
    }

    @JsonIgnore
    public boolean isFail() {
        return this.name.equals("FAIL");
    }

    @JsonIgnore
    public boolean isSync() {
        return this.name.equals("SYNC");
    }

    @JsonIgnore
    public String getLabel() {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.get(METADATA_LABEL);
    }

    @JsonIgnore
    public void setLabel(String label) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(METADATA_LABEL, label);
    }
}

