/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.dsl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.dsl.Stream;
import org.springframework.cloud.dataflow.rest.client.dsl.StreamApplication;
import org.springframework.util.StringUtils;

public class StreamDefinition {
    private String name;
    private DataFlowOperations client;
    private String definition;
    private String description;
    private List<StreamApplication> applications;

    public StreamDefinition(String name, DataFlowOperations client, String definition, String description, List<StreamApplication> applications) {
        this.name = name;
        this.client = client;
        this.definition = definition;
        this.description = description;
        this.applications = applications;
        if (StringUtils.isEmpty((Object)definition)) {
            this.createStreamDefinition();
        }
        this.client.streamOperations().createStream(this.name, this.definition, this.description, false);
    }

    public void destroy() {
        this.client.streamOperations().destroy(this.name);
    }

    public Stream deploy(Map<String, String> deploymentProperties) {
        Map<String, String> resolvedProperties = this.resolveDeploymentProperties(deploymentProperties);
        this.client.streamOperations().deploy(this.name, resolvedProperties);
        return new Stream(this.name, this.applications, this.definition, this.description, this.client);
    }

    public Stream deploy() {
        return this.deploy(null);
    }

    private void createStreamDefinition() {
        this.definition = StringUtils.collectionToDelimitedString(this.applications, (String)" | ");
    }

    private Map<String, String> resolveDeploymentProperties(Map<String, String> deploymentProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (deploymentProperties != null) {
            properties.putAll(deploymentProperties);
        }
        for (StreamApplication app : this.applications) {
            for (Map.Entry<String, Object> entry : app.getDeploymentProperties().entrySet()) {
                properties.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return properties;
    }
}

