/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientPropertiesRegistrationAdapter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.common.security.core.support.OAuth2AccessTokenProvidingClientHttpRequestInterceptor;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.DataFlowTemplate;
import org.springframework.cloud.dataflow.rest.client.config.DataFlowClientProperties;
import org.springframework.cloud.dataflow.rest.client.dsl.Stream;
import org.springframework.cloud.dataflow.rest.client.dsl.StreamBuilder;
import org.springframework.cloud.dataflow.rest.util.HttpClientConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.endpoint.DefaultClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={DataFlowClientProperties.class})
public class DataFlowClientAutoConfiguration {
    private static Log logger = LogFactory.getLog(DataFlowClientAutoConfiguration.class);
    private static final String DEFAULT_REGISTRATION_ID = "default";
    @Autowired
    private DataFlowClientProperties properties;
    private RestTemplate restTemplate;
    @Autowired
    @Nullable
    private ClientRegistrationRepository clientRegistrations;
    @Autowired
    @Nullable
    private OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient;
    @Autowired
    @Nullable
    private OAuth2ClientProperties oauth2ClientProperties;
    private static final Authentication DEFAULT_PRINCIPAL = DataFlowClientAutoConfiguration.createAuthentication("dataflow-client-principal");

    public DataFlowClientAutoConfiguration(@Nullable RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(value={DataFlowOperations.class})
    public DataFlowOperations dataFlowOperations(@Nullable ObjectMapper mapper) throws Exception {
        RestTemplate template = DataFlowTemplate.prepareRestTemplate(this.restTemplate);
        HttpClientConfigurer httpClientConfigurer = HttpClientConfigurer.create((URI)new URI(this.properties.getServerUri())).skipTlsCertificateVerification(this.properties.isSkipSslValidation());
        if (StringUtils.hasText((String)this.properties.getAuthentication().getAccessToken())) {
            template.getInterceptors().add(new OAuth2AccessTokenProvidingClientHttpRequestInterceptor(this.properties.getAuthentication().getAccessToken()));
            logger.debug((Object)"Configured OAuth2 Access Token for accessing the Data Flow Server");
        } else if (StringUtils.hasText((String)this.properties.getAuthentication().getClientId())) {
            ClientRegistration clientRegistration = this.clientRegistrations.findByRegistrationId(DEFAULT_REGISTRATION_ID);
            template.getInterceptors().add(this.clientCredentialsTokenResolvingInterceptor(clientRegistration, this.clientRegistrations, this.properties.getAuthentication().getClientId()));
            logger.debug((Object)"Configured OAuth2 Client Credentials for accessing the Data Flow Server");
        } else if (!StringUtils.isEmpty((Object)this.properties.getAuthentication().getBasic().getUsername()) && !StringUtils.isEmpty((Object)this.properties.getAuthentication().getBasic().getPassword())) {
            httpClientConfigurer.basicAuthCredentials(this.properties.getAuthentication().getBasic().getUsername(), this.properties.getAuthentication().getBasic().getPassword());
            template.setRequestFactory(httpClientConfigurer.buildClientHttpRequestFactory());
        } else if (this.oauth2ClientProperties != null && !this.oauth2ClientProperties.getRegistration().isEmpty() && StringUtils.hasText((String)this.properties.getAuthentication().getOauth2().getUsername()) && StringUtils.hasText((String)this.properties.getAuthentication().getOauth2().getPassword())) {
            ClientHttpRequestInterceptor bearerTokenResolvingInterceptor = this.bearerTokenResolvingInterceptor(this.oauth2ClientProperties, this.properties.getAuthentication().getOauth2().getUsername(), this.properties.getAuthentication().getOauth2().getPassword(), this.properties.getAuthentication().getOauth2().getClientRegistrationId());
            template.getInterceptors().add(bearerTokenResolvingInterceptor);
            logger.debug((Object)"Configured OAuth2 Bearer Token resolving for accessing the Data Flow Server");
        } else {
            logger.debug((Object)"Not configuring security for accessing the Data Flow Server");
        }
        return new DataFlowTemplate(new URI(this.properties.getServerUri()), template, mapper);
    }

    @Bean
    @ConditionalOnMissingBean(value={StreamBuilder.class})
    public StreamBuilder streamBuilder(DataFlowOperations dataFlowOperations) {
        return Stream.builder(dataFlowOperations);
    }

    private ClientHttpRequestInterceptor clientCredentialsTokenResolvingInterceptor(ClientRegistration clientRegistration, ClientRegistrationRepository clientRegistrationRepository, String clientId) {
        Authentication principal = DataFlowClientAutoConfiguration.createAuthentication(clientId);
        InMemoryOAuth2AuthorizedClientService authorizedClientService = new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
        AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, (OAuth2AuthorizedClientService)authorizedClientService);
        OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().clientCredentials().build();
        authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
        OAuth2AuthorizeRequest authorizeRequest = OAuth2AuthorizeRequest.withClientRegistrationId((String)DEFAULT_REGISTRATION_ID).principal(principal).build();
        return (request, body, execution) -> {
            OAuth2AuthorizedClient authorizedClient = authorizedClientManager.authorize(authorizeRequest);
            request.getHeaders().setBearerAuth(authorizedClient.getAccessToken().getTokenValue());
            return execution.execute(request, body);
        };
    }

    private ClientRegistrationRepository shellClientRegistrationRepository(OAuth2ClientProperties properties) {
        ArrayList registrations = new ArrayList(OAuth2ClientPropertiesRegistrationAdapter.getClientRegistrations((OAuth2ClientProperties)properties).values());
        return new InMemoryClientRegistrationRepository(registrations);
    }

    private OAuth2AuthorizedClientService shellAuthorizedClientService(ClientRegistrationRepository shellClientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(shellClientRegistrationRepository);
    }

    private OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository shellClientRegistrationRepository, OAuth2AuthorizedClientService shellAuthorizedClientService) {
        AuthorizedClientServiceOAuth2AuthorizedClientManager manager = new AuthorizedClientServiceOAuth2AuthorizedClientManager(shellClientRegistrationRepository, shellAuthorizedClientService);
        OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().password().refreshToken().build();
        manager.setAuthorizedClientProvider(authorizedClientProvider);
        manager.setContextAttributesMapper(request -> {
            HashMap contextAttributes = new HashMap();
            request.getAttributes().forEach((k, v) -> {
                if (OAuth2AuthorizationContext.USERNAME_ATTRIBUTE_NAME.equals(k) || OAuth2AuthorizationContext.PASSWORD_ATTRIBUTE_NAME.equals(k)) {
                    contextAttributes.put(k, v);
                }
            });
            return contextAttributes;
        });
        return manager;
    }

    private ClientHttpRequestInterceptor bearerTokenResolvingInterceptor(OAuth2ClientProperties properties, String username, String password, String clientRegistrationId) {
        ClientRegistrationRepository shellClientRegistrationRepository = this.shellClientRegistrationRepository(properties);
        OAuth2AuthorizedClientService shellAuthorizedClientService = this.shellAuthorizedClientService(shellClientRegistrationRepository);
        OAuth2AuthorizedClientManager authorizedClientManager = this.authorizedClientManager(shellClientRegistrationRepository, shellAuthorizedClientService);
        if (properties.getRegistration() != null && properties.getRegistration().size() == 1) {
            clientRegistrationId = (String)properties.getRegistration().entrySet().iterator().next().getKey();
        }
        OAuth2AuthorizeRequest authorizeRequest = OAuth2AuthorizeRequest.withClientRegistrationId((String)clientRegistrationId).principal(DEFAULT_PRINCIPAL).attribute(OAuth2AuthorizationContext.USERNAME_ATTRIBUTE_NAME, (Object)username).attribute(OAuth2AuthorizationContext.PASSWORD_ATTRIBUTE_NAME, (Object)password).build();
        return (request, body, execution) -> {
            OAuth2AuthorizedClient authorizedClient = authorizedClientManager.authorize(authorizeRequest);
            request.getHeaders().setBearerAuth(authorizedClient.getAccessToken().getTokenValue());
            return execution.execute(request, body);
        };
    }

    private static Authentication createAuthentication(final String principalName) {
        return new AbstractAuthenticationToken(null){
            private static final long serialVersionUID = -2038812908189509872L;

            public Object getCredentials() {
                return "";
            }

            public Object getPrincipal() {
                return principalName;
            }
        };
    }

    @ConditionalOnProperty(prefix="spring.cloud.dataflow.client.authentication", name={"client-id"})
    @Configuration
    static class ClientCredentialsConfiguration {
        ClientCredentialsConfiguration() {
        }

        @Bean
        public InMemoryClientRegistrationRepository clientRegistrationRepository(DataFlowClientProperties properties) {
            ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)DataFlowClientAutoConfiguration.DEFAULT_REGISTRATION_ID).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).tokenUri(properties.getAuthentication().getTokenUri()).clientId(properties.getAuthentication().getClientId()).clientSecret(properties.getAuthentication().getClientSecret()).scope(properties.getAuthentication().getScope()).build();
            return new InMemoryClientRegistrationRepository(new ClientRegistration[]{clientRegistration});
        }

        @Bean
        OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient() {
            return new DefaultClientCredentialsTokenResponseClient();
        }
    }
}

