/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import org.springframework.cloud.dataflow.rest.client.JobOperations;
import org.springframework.cloud.dataflow.rest.resource.JobExecutionResource;
import org.springframework.cloud.dataflow.rest.resource.JobExecutionThinResource;
import org.springframework.cloud.dataflow.rest.resource.JobInstanceResource;
import org.springframework.cloud.dataflow.rest.resource.StepExecutionProgressInfoResource;
import org.springframework.cloud.dataflow.rest.resource.StepExecutionResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class JobTemplate
implements JobOperations {
    private static final String EXECUTIONS_RELATION = "jobs/thinexecutions";
    private static final String EXECUTION_RELATION = "jobs/executions/execution";
    private static final String EXECUTION_RELATION_BY_NAME = "jobs/thinexecutions/name";
    private static final String INSTANCE_RELATION = "jobs/instances/instance";
    private static final String INSTANCE_RELATION_BY_NAME = "jobs/instances/name";
    private static final String STEP_EXECUTION_RELATION_BY_ID = "jobs/executions/execution/steps";
    private static final String STEP_EXECUTION_PROGRESS_RELATION_BY_ID = "jobs/executions/execution/steps/step/progress";
    private final RestTemplate restTemplate;
    private final Link executionsLink;
    private final Link executionLink;
    private final Link executionByNameLink;
    private final Link instanceLink;
    private final Link instanceByNameLink;
    private final Link stepExecutionsLink;
    private final Link stepExecutionProgressLink;

    JobTemplate(RestTemplate restTemplate, RepresentationModel<?> resources) {
        Assert.notNull(resources, (String)"URI CollectionModel must not be be null");
        Assert.notNull((Object)restTemplate, (String)"RestTemplate must not be null");
        Assert.notNull((Object)resources.getLink(EXECUTIONS_RELATION), (String)"Executions relation is required");
        Assert.notNull((Object)resources.getLink(EXECUTION_RELATION), (String)"Execution relation is required");
        Assert.notNull((Object)resources.getLink(EXECUTION_RELATION_BY_NAME), (String)"Execution by name relation is required");
        Assert.notNull((Object)resources.getLink(INSTANCE_RELATION), (String)"Instance relation is required");
        Assert.notNull((Object)resources.getLink(INSTANCE_RELATION_BY_NAME), (String)"Instance by name relation is required");
        Assert.notNull((Object)resources.getLink(STEP_EXECUTION_RELATION_BY_ID), (String)"Step Execution by id relation is required");
        Assert.notNull((Object)resources.getLink(STEP_EXECUTION_PROGRESS_RELATION_BY_ID), (String)"Step Execution Progress by id relation is required");
        Assert.notNull((Object)resources.getLink(STEP_EXECUTION_PROGRESS_RELATION_BY_ID), (String)"Step Execution View by id relation is required");
        this.restTemplate = restTemplate;
        this.executionsLink = (Link)resources.getLink(EXECUTIONS_RELATION).get();
        this.executionLink = (Link)resources.getLink(EXECUTION_RELATION).get();
        this.executionByNameLink = (Link)resources.getLink(EXECUTION_RELATION_BY_NAME).get();
        this.instanceLink = (Link)resources.getLink(INSTANCE_RELATION).get();
        this.instanceByNameLink = (Link)resources.getLink(INSTANCE_RELATION_BY_NAME).get();
        this.stepExecutionsLink = (Link)resources.getLink(STEP_EXECUTION_RELATION_BY_ID).get();
        this.stepExecutionProgressLink = (Link)resources.getLink(STEP_EXECUTION_PROGRESS_RELATION_BY_ID).get();
    }

    @Override
    public PagedModel<JobExecutionResource> executionList() {
        String uriTemplate = this.executionsLink.getHref();
        uriTemplate = uriTemplate + "?size=2000";
        return (PagedModel)this.restTemplate.getForObject(uriTemplate, JobExecutionResource.Page.class, new Object[0]);
    }

    @Override
    public void executionRestart(long id) {
        String uriTemplate = this.executionLink.expand(new Object[]{id}).getHref();
        uriTemplate = uriTemplate + "?restart=true";
        this.restTemplate.put(uriTemplate, null, new Object[0]);
    }

    @Override
    public PagedModel<JobExecutionThinResource> executionThinList() {
        String uriTemplate = this.executionsLink.getHref();
        uriTemplate = uriTemplate + "?size=2000";
        return (PagedModel)this.restTemplate.getForObject(uriTemplate, JobExecutionThinResource.Page.class, new Object[0]);
    }

    @Override
    public PagedModel<JobInstanceResource> instanceList(String jobName) {
        return (PagedModel)this.restTemplate.getForObject(this.instanceByNameLink.expand(new Object[]{jobName}).getHref(), JobInstanceResource.Page.class, new Object[0]);
    }

    @Override
    public PagedModel<JobExecutionThinResource> executionThinListByJobName(String jobName) {
        return (PagedModel)this.restTemplate.getForObject(this.executionByNameLink.expand(new Object[]{jobName}).getHref(), JobExecutionThinResource.Page.class, new Object[0]);
    }

    @Override
    public PagedModel<JobExecutionResource> executionListByJobName(String jobName) {
        return (PagedModel)this.restTemplate.getForObject(this.executionByNameLink.expand(new Object[]{jobName}).getHref(), JobExecutionResource.Page.class, new Object[0]);
    }

    @Override
    public JobExecutionResource jobExecution(long id) {
        return (JobExecutionResource)this.restTemplate.getForObject(this.executionLink.expand(new Object[]{id}).getHref(), JobExecutionResource.class, new Object[0]);
    }

    @Override
    public JobInstanceResource jobInstance(long id) {
        return (JobInstanceResource)this.restTemplate.getForObject(this.instanceLink.expand(new Object[]{id}).getHref(), JobInstanceResource.class, new Object[0]);
    }

    @Override
    public PagedModel<StepExecutionResource> stepExecutionList(long jobExecutionId) {
        return (PagedModel)this.restTemplate.getForObject(this.stepExecutionsLink.expand(new Object[]{jobExecutionId}).getHref(), StepExecutionResource.Page.class, new Object[0]);
    }

    @Override
    public StepExecutionProgressInfoResource stepExecutionProgress(long jobExecutionId, long stepExecutionId) {
        return (StepExecutionProgressInfoResource)this.restTemplate.getForObject(this.stepExecutionProgressLink.expand(new Object[]{jobExecutionId, stepExecutionId}).getHref(), StepExecutionProgressInfoResource.class, new Object[0]);
    }
}

