/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import org.springframework.cloud.dataflow.rest.client.RuntimeOperations;
import org.springframework.cloud.dataflow.rest.resource.AppStatusResource;
import org.springframework.cloud.dataflow.rest.resource.StreamStatusResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.web.client.RestTemplate;

public class RuntimeTemplate
implements RuntimeOperations {
    private final RestTemplate restTemplate;
    private final Link appStatusesUriTemplate;
    private final Link appStatusUriTemplate;
    private final Link streamStatusUriTemplate;

    RuntimeTemplate(RestTemplate restTemplate, RepresentationModel<?> resources) {
        this.restTemplate = restTemplate;
        this.appStatusesUriTemplate = (Link)resources.getLink("runtime/apps").get();
        this.appStatusUriTemplate = (Link)resources.getLink("runtime/apps/{appId}").get();
        this.streamStatusUriTemplate = (Link)resources.getLink("runtime/streams/{streamNames}").get();
    }

    @Override
    public PagedModel<AppStatusResource> status() {
        String uriTemplate = this.appStatusesUriTemplate.expand(new Object[0]).getHref();
        uriTemplate = uriTemplate + "?size=2000";
        return (PagedModel)this.restTemplate.getForObject(uriTemplate, AppStatusResource.Page.class, new Object[0]);
    }

    @Override
    public AppStatusResource status(String deploymentId) {
        return (AppStatusResource)this.restTemplate.getForObject(this.appStatusUriTemplate.expand(new Object[]{deploymentId}).getHref(), AppStatusResource.class, new Object[0]);
    }

    @Override
    public PagedModel<StreamStatusResource> streamStatus(String ... streamNames) {
        return (PagedModel)this.restTemplate.getForObject(this.streamStatusUriTemplate.expand((Object[])streamNames).getHref(), StreamStatusResource.Page.class, new Object[0]);
    }
}

