/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.dsl.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.JobOperations;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.dataflow.rest.client.dsl.task.TaskBuilder;
import org.springframework.cloud.dataflow.rest.resource.JobExecutionResource;
import org.springframework.cloud.dataflow.rest.resource.JobInstanceResource;
import org.springframework.cloud.dataflow.rest.resource.TaskDefinitionResource;
import org.springframework.cloud.dataflow.rest.resource.TaskExecutionResource;
import org.springframework.cloud.dataflow.rest.resource.TaskExecutionStatus;
import org.springframework.util.StringUtils;

public class Task
implements AutoCloseable {
    private final String taskName;
    private final TaskOperations taskOperations;
    private final JobOperations jobOperations;
    private final DataFlowOperations dataFlowOperations;

    Task(String taskName, DataFlowOperations dataFlowOperations) {
        this.taskName = taskName;
        this.dataFlowOperations = dataFlowOperations;
        this.taskOperations = dataFlowOperations.taskOperations();
        this.jobOperations = dataFlowOperations.jobOperations();
    }

    public static TaskBuilder builder(DataFlowOperations dataFlowOperations) {
        return new TaskBuilder(dataFlowOperations);
    }

    public long launch() {
        return this.launch(Collections.EMPTY_LIST);
    }

    public long launch(List<String> arguments) {
        return this.launch(Collections.EMPTY_MAP, arguments);
    }

    public long launch(Map<String, String> properties, List<String> arguments) {
        if (properties == null) {
            throw new IllegalArgumentException("Task properties can't be null!");
        }
        return this.taskOperations.launch(this.taskName, properties, arguments, null);
    }

    public void stop() {
        String commaSeparatedIds = this.executions().stream().filter(Objects::nonNull).filter(e -> e.getTaskExecutionStatus() == TaskExecutionStatus.RUNNING).map(TaskExecutionResource::getExecutionId).map(String::valueOf).collect(Collectors.joining(","));
        if (StringUtils.hasText((String)commaSeparatedIds)) {
            this.taskOperations.stop(commaSeparatedIds);
        }
    }

    public void stop(long ... taskExecutionIds) {
        String commaSeparatedIds = Stream.of(taskExecutionIds).map(String::valueOf).collect(Collectors.joining(","));
        if (StringUtils.hasText((String)commaSeparatedIds)) {
            this.taskOperations.stop(commaSeparatedIds);
        }
    }

    public void destroy() {
        this.taskOperations.destroy(this.taskName);
    }

    public Collection<TaskExecutionResource> executions() {
        return this.taskOperations.executionListByTaskName(this.taskName).getContent();
    }

    public Optional<TaskExecutionResource> execution(long executionId) {
        return this.executions().stream().filter(Objects::nonNull).filter(e -> e.getExecutionId() == executionId).findFirst();
    }

    public Optional<TaskExecutionResource> executionByParentExecutionId(long parentExecutionId) {
        return this.executions().stream().filter(Objects::nonNull).filter(e -> e.getParentExecutionId() == parentExecutionId).findFirst();
    }

    public TaskExecutionStatus executionStatus(long executionId) {
        return this.execution(executionId).map(TaskExecutionResource::getTaskExecutionStatus).orElse(TaskExecutionStatus.UNKNOWN);
    }

    public boolean isComposed() {
        return this.definitionResource().map(TaskDefinitionResource::isComposed).orElse(false);
    }

    public List<Task> composedTaskChildTasks() {
        return !this.isComposed() ? new ArrayList<Task>() : this.taskOperations.list().getContent().stream().filter(Objects::nonNull).filter(t -> t.getName().startsWith(this.taskName + "-")).map(t -> new Task(t.getName(), this.dataFlowOperations)).collect(Collectors.toList());
    }

    public Collection<JobExecutionResource> jobExecutionResources() {
        return this.jobOperations.executionListByJobName(this.taskName).getContent();
    }

    public Collection<JobInstanceResource> jobInstanceResources() {
        return this.jobOperations.instanceList(this.taskName).getContent();
    }

    private Optional<TaskDefinitionResource> definitionResource() {
        return this.taskOperations.list().getContent().stream().filter(Objects::nonNull).filter(t -> t.getName().equals(this.taskName)).findFirst();
    }

    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public void close() {
        this.destroy();
    }
}

