/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.support;

import com.vdurmont.semver4j.Semver;
import org.springframework.util.StringUtils;

public abstract class VersionUtils {
    private static String SEPARATOR = ".";

    public static String getThreePartVersion(String fourPartVersion) {
        String threePartVersion = "";
        String[] versionTokens = StringUtils.delimitedListToStringArray((String)fourPartVersion, (String)SEPARATOR);
        if (versionTokens.length == 3) {
            return fourPartVersion;
        }
        if (versionTokens.length != 4) {
            return threePartVersion;
        }
        return versionTokens[0] + SEPARATOR + versionTokens[1] + SEPARATOR + versionTokens[2];
    }

    public static boolean isDataFlowServerVersionGreaterThanOrEqualToRequiredVersion(String dataFlowServerVersion, String requiredVersion) {
        boolean result = false;
        String[] dataFlowServerVersionTokens = StringUtils.delimitedListToStringArray((String)dataFlowServerVersion, (String)SEPARATOR);
        String[] requiredVersionTokens = StringUtils.delimitedListToStringArray((String)requiredVersion, (String)SEPARATOR);
        if (dataFlowServerVersionTokens.length != 3 && requiredVersionTokens.length != 3) {
            return result;
        }
        try {
            Semver requiredVersionSemver = new Semver(requiredVersion);
            Semver dataFlowServerVersionSemver = new Semver(dataFlowServerVersion);
            result = dataFlowServerVersionSemver.isGreaterThanOrEqualTo(requiredVersionSemver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

