/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.util;

import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.springframework.cloud.dataflow.rest.util.HttpUtils;
import org.springframework.cloud.dataflow.rest.util.PreemptiveBasicAuthHttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.Assert;

public class HttpClientConfigurer {
    private final HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
    private boolean useBasicAuth;
    private HttpHost targetHost;
    private CredentialsProvider credentialsProvider;

    public static HttpClientConfigurer create(URI targetHost) {
        return new HttpClientConfigurer(targetHost);
    }

    protected HttpClientConfigurer(URI targetHost) {
        this.targetHost = new HttpHost(targetHost.getHost(), targetHost.getPort(), targetHost.getScheme());
    }

    public HttpClientConfigurer basicAuthCredentials(String username, String password) {
        CredentialsProvider credentialsProvider = this.getOrInitializeCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(this.targetHost), (Credentials)new UsernamePasswordCredentials(username, password));
        this.httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        this.useBasicAuth = true;
        return this;
    }

    private CredentialsProvider getOrInitializeCredentialsProvider() {
        if (this.credentialsProvider == null) {
            this.credentialsProvider = new BasicCredentialsProvider();
        }
        return this.credentialsProvider;
    }

    public HttpClientConfigurer withProxyCredentials(URI proxyUri, String proxyUsername, String proxyPassword) {
        Assert.notNull((Object)proxyUri, (String)"The proxyUri must not be null.");
        Assert.hasText((String)proxyUri.getScheme(), (String)"The scheme component of the proxyUri must not be empty.");
        this.httpClientBuilder.setProxy(new HttpHost(proxyUri.getHost(), proxyUri.getPort(), proxyUri.getScheme()));
        if (proxyUsername != null && proxyPassword != null) {
            CredentialsProvider credentialsProvider = this.getOrInitializeCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxyUri.getHost(), proxyUri.getPort()), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
            this.httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
        }
        return this;
    }

    public HttpClientConfigurer skipTlsCertificateVerification() {
        this.httpClientBuilder.setSSLContext(HttpUtils.buildCertificateIgnoringSslContext());
        this.httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        return this;
    }

    public HttpClientConfigurer skipTlsCertificateVerification(boolean skipTlsCertificateVerification) {
        if (skipTlsCertificateVerification) {
            this.skipTlsCertificateVerification();
        }
        return this;
    }

    public HttpClientConfigurer addInterceptor(HttpRequestInterceptor interceptor) {
        this.httpClientBuilder.addInterceptorLast(interceptor);
        return this;
    }

    public CloseableHttpClient buildHttpClient() {
        return this.httpClientBuilder.build();
    }

    public ClientHttpRequestFactory buildClientHttpRequestFactory() {
        if (this.useBasicAuth && this.targetHost != null) {
            return new PreemptiveBasicAuthHttpComponentsClientHttpRequestFactory((HttpClient)this.buildHttpClient(), this.targetHost);
        }
        return new HttpComponentsClientHttpRequestFactory((HttpClient)this.buildHttpClient());
    }
}

