/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.schema;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import org.springframework.cloud.dataflow.schema.AppBootSchemaVersionDeserializer;
import org.springframework.cloud.dataflow.schema.AppBootSchemaVersionSerializer;

@JsonSerialize(using=AppBootSchemaVersionSerializer.class)
@JsonDeserialize(using=AppBootSchemaVersionDeserializer.class)
public enum AppBootSchemaVersion {
    BOOT2("2"),
    BOOT3("3");

    private String bootVersion;

    private AppBootSchemaVersion(String bootVersion) {
        this.bootVersion = bootVersion;
    }

    public static AppBootSchemaVersion defaultVersion() {
        return BOOT2;
    }

    public static AppBootSchemaVersion fromBootVersion(String bootVersion) {
        return Arrays.stream(AppBootSchemaVersion.values()).filter(bv -> bv.bootVersion.equals(bootVersion)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid AppBootSchemaVersion: " + bootVersion));
    }

    public String getBootVersion() {
        return this.bootVersion;
    }

    public String toString() {
        return "AppBootVersion{bootVersion='" + this.bootVersion + "'}";
    }
}

