/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.schema;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.util.Assert;

public class AggregateTaskExecution {
    private long executionId;
    private Long parentExecutionId;
    private Integer exitCode;
    private String taskName;
    private Date startTime;
    private Date endTime;
    private String exitMessage;
    private String externalExecutionId;
    private String errorMessage;
    private String schemaTarget;
    private String platformName;
    private String ctrTaskStatus;
    private List<String> arguments;

    public AggregateTaskExecution() {
        this.arguments = new ArrayList<String>();
    }

    public AggregateTaskExecution(long executionId, Integer exitCode, String taskName, Date startTime, Date endTime, String exitMessage, List<String> arguments, String errorMessage, String externalExecutionId, Long parentExecutionId, String platformName, String ctrTaskStatus, String schemaTarget) {
        Assert.notNull(arguments, (String)"arguments must not be null");
        this.executionId = executionId;
        this.exitCode = exitCode;
        this.taskName = taskName;
        this.exitMessage = exitMessage;
        this.arguments = new ArrayList<String>(arguments);
        this.startTime = startTime != null ? (Date)startTime.clone() : null;
        this.endTime = endTime != null ? (Date)endTime.clone() : null;
        this.errorMessage = errorMessage;
        this.externalExecutionId = externalExecutionId;
        this.parentExecutionId = parentExecutionId;
        this.schemaTarget = schemaTarget;
        this.platformName = platformName;
        this.ctrTaskStatus = ctrTaskStatus;
    }

    public AggregateTaskExecution(long executionId, Integer exitCode, String taskName, Date startTime, Date endTime, String exitMessage, List<String> arguments, String errorMessage, String externalExecutionId, String platformName, String ctrTaskStatus, String schemaTarget) {
        this(executionId, exitCode, taskName, startTime, endTime, exitMessage, arguments, errorMessage, externalExecutionId, null, platformName, ctrTaskStatus, schemaTarget);
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Date getStartTime() {
        return this.startTime != null ? (Date)this.startTime.clone() : null;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime != null ? (Date)startTime.clone() : null;
    }

    public Date getEndTime() {
        return this.endTime != null ? (Date)this.endTime.clone() : null;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime != null ? (Date)endTime.clone() : null;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public void setExitMessage(String exitMessage) {
        this.exitMessage = exitMessage;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = new ArrayList<String>(arguments);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getExternalExecutionId() {
        return this.externalExecutionId;
    }

    public void setExternalExecutionId(String externalExecutionId) {
        this.externalExecutionId = externalExecutionId;
    }

    public Long getParentExecutionId() {
        return this.parentExecutionId;
    }

    public void setParentExecutionId(Long parentExecutionId) {
        this.parentExecutionId = parentExecutionId;
    }

    public String getSchemaTarget() {
        return this.schemaTarget;
    }

    public void setSchemaTarget(String schemaTarget) {
        this.schemaTarget = schemaTarget;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getCtrTaskStatus() {
        return this.ctrTaskStatus;
    }

    public void setCtrTaskStatus(String ctrTaskStatus) {
        this.ctrTaskStatus = ctrTaskStatus;
    }

    public String toString() {
        return "AggregateTaskExecution{executionId=" + this.executionId + ", parentExecutionId=" + this.parentExecutionId + ", exitCode=" + this.exitCode + ", taskName='" + this.taskName + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", exitMessage='" + this.exitMessage + '\'' + ", externalExecutionId='" + this.externalExecutionId + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", schemaTarget='" + this.schemaTarget + '\'' + ", platformName='" + this.platformName + '\'' + ", ctrTaskStatus='" + this.ctrTaskStatus + '\'' + ", arguments=" + this.arguments + '}';
    }

    public TaskExecution toTaskExecution() {
        return new TaskExecution(this.executionId, this.exitCode, this.taskName, this.startTime, this.endTime, this.exitMessage, this.arguments, this.errorMessage, this.externalExecutionId, this.parentExecutionId);
    }
}

