/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.schema;

import java.util.Objects;
import org.springframework.cloud.dataflow.schema.AppBootSchemaVersion;

public class SchemaVersionTarget {
    private String name;
    private AppBootSchemaVersion schemaVersion;
    private String taskPrefix;
    private String batchPrefix;
    private String datasource;

    public SchemaVersionTarget() {
    }

    public SchemaVersionTarget(String name, AppBootSchemaVersion schemaVersion, String taskPrefix, String batchPrefix, String datasource) {
        this.name = name;
        this.schemaVersion = schemaVersion;
        this.taskPrefix = taskPrefix;
        this.batchPrefix = batchPrefix;
        this.datasource = datasource;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AppBootSchemaVersion getSchemaVersion() {
        return this.schemaVersion == null ? AppBootSchemaVersion.defaultVersion() : this.schemaVersion;
    }

    public void setSchemaVersion(AppBootSchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String getTaskPrefix() {
        return this.taskPrefix;
    }

    public void setTaskPrefix(String taskPrefix) {
        this.taskPrefix = taskPrefix;
    }

    public String getBatchPrefix() {
        return this.batchPrefix;
    }

    public void setBatchPrefix(String batchPrefix) {
        this.batchPrefix = batchPrefix;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaVersionTarget that = (SchemaVersionTarget)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public static SchemaVersionTarget createDefault(AppBootSchemaVersion schemaVersion) {
        if (schemaVersion.equals((Object)AppBootSchemaVersion.defaultVersion())) {
            return new SchemaVersionTarget(schemaVersion.name().toLowerCase(), schemaVersion, "TASK_", "BATCH_", null);
        }
        return new SchemaVersionTarget(schemaVersion.name().toLowerCase(), schemaVersion, schemaVersion.name() + "_TASK_", schemaVersion.name() + "_BATCH_", null);
    }

    public static SchemaVersionTarget defaultTarget() {
        return SchemaVersionTarget.createDefault(AppBootSchemaVersion.defaultVersion());
    }

    public String toString() {
        return "SchemaVersionTarget{name='" + this.name + '\'' + ", schemaVersion=" + (Object)((Object)this.schemaVersion) + ", taskPrefix='" + this.taskPrefix + '\'' + ", batchPrefix='" + this.batchPrefix + '\'' + ", datasource='" + this.datasource + '\'' + '}';
    }
}

