/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.autoconfigure.DelegatingResourceLoaderBuilder;
import org.springframework.cloud.deployer.autoconfigure.DelegatingResourceLoaderBuilderCustomizer;
import org.springframework.cloud.deployer.autoconfigure.MavenConfigurationProperties;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResourceLoader;
import org.springframework.cloud.deployer.resource.support.DelegatingResourceLoader;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ResourceLoader;

@Configuration
public class ResourceLoadingAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={DelegatingResourceLoader.class})
    public static class DelegatingResourceLoaderConfig {
        private final ObjectProvider<DelegatingResourceLoaderBuilderCustomizer> loaderBuilderCustomizers;

        public DelegatingResourceLoaderConfig(ObjectProvider<DelegatingResourceLoaderBuilderCustomizer> loaderBuilderCustomizers) {
            this.loaderBuilderCustomizers = loaderBuilderCustomizers;
        }

        @Bean
        public DelegatingResourceLoader delegatingResourceLoader() {
            DelegatingResourceLoaderBuilder builder = new DelegatingResourceLoaderBuilder();
            this.loaderBuilderCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder.build();
        }
    }

    @Configuration
    @ConditionalOnClass(value={MavenResourceLoader.class})
    @EnableConfigurationProperties(value={MavenConfigurationProperties.class})
    public static class MavenResourceLoaderConfig {
        @Bean
        @Order(value=0)
        public DelegatingResourceLoaderBuilderCustomizer mavenDelegatingResourceLoaderBuilderCustomizer(MavenProperties mavenProperties) {
            return customizer -> customizer.loader("maven", (ResourceLoader)new MavenResourceLoader(mavenProperties));
        }
    }
}

