/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.thin;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.thin.ThinJarAppWrapper;
import org.springframework.util.StringUtils;

public class AbstractThinJarSupport {
    private static final String JMX_DEFAULT_DOMAIN_KEY = "spring.jmx.default-domain";
    private Map<String, ThinJarAppWrapper> apps = new LinkedHashMap<String, ThinJarAppWrapper>();
    private String name = "thin";
    private String[] profiles = new String[0];

    public AbstractThinJarSupport() {
        this("thin", new String[0]);
    }

    public AbstractThinJarSupport(String name, String ... profiles) {
        this.name = name;
        this.profiles = profiles;
    }

    public String deploy(AppDeploymentRequest request) {
        ThinJarAppWrapper wrapper = new ThinJarAppWrapper(request.getResource(), this.getName(request), this.getProfiles(request));
        String id = wrapper.getId();
        if (!this.apps.containsKey(id)) {
            this.apps.put(id, wrapper);
        } else {
            wrapper = this.apps.get(id);
        }
        wrapper.run(this.getProperties(request), request.getCommandlineArguments());
        return id;
    }

    protected Map<String, String> getProperties(AppDeploymentRequest request) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(request.getDefinition().getProperties());
        String group = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        if (group == null) {
            group = "deployer";
        }
        String deploymentId = String.format("%s.%s", group, request.getDefinition().getName());
        properties.put(JMX_DEFAULT_DOMAIN_KEY, deploymentId);
        properties.put("endpoints.shutdown.enabled", "true");
        properties.put("endpoints.jmx.unique-names", "true");
        if (group != null) {
            properties.put("spring.cloud.application.group", group);
        }
        return properties;
    }

    private String[] getProfiles(AppDeploymentRequest request) {
        if (request.getDeploymentProperties().containsKey("spring.cloud.deployer.thin.profile")) {
            return StringUtils.commaDelimitedListToStringArray((String)((String)request.getDeploymentProperties().get("spring.cloud.deployer.thin.profile")));
        }
        return this.profiles;
    }

    private String getName(AppDeploymentRequest request) {
        if (request.getDeploymentProperties().containsKey("spring.cloud.deployer.thin.name")) {
            return (String)request.getDeploymentProperties().get("spring.cloud.deployer.thin.name");
        }
        return this.name;
    }

    public void cancel(String id) {
        if (this.apps.containsKey(id)) {
            this.apps.get(id).cancel();
        }
    }

    protected ThinJarAppWrapper getWrapper(String id) {
        return this.apps.get(id);
    }
}

