/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.thin;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.deployer.thin.JdbcLeakPrevention;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.ClassUtils;

public class ContextRunner {
    private ConfigurableApplicationContext context;
    private Thread runThread;
    private boolean running = false;
    private Throwable error;
    private long timeout = 120000L;

    public void run(final String source, final Map<String, Object> properties, final String ... args) {
        this.runThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StandardEnvironment environment = new StandardEnvironment();
                    environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)new MapPropertySource("appDeployer", properties));
                    String main = source;
                    if (source == null) {
                        main = SpringApplication.class.getName();
                    }
                    SpringApplicationBuilder builder = ContextRunner.builder(main).registerShutdownHook(false).environment((ConfigurableEnvironment)environment);
                    ContextRunner.this.context = builder.run(args);
                }
                catch (Throwable ex) {
                    ContextRunner.this.error = ex;
                }
            }
        });
        this.runThread.start();
        try {
            this.runThread.join(this.timeout);
            this.runThread.setContextClassLoader(null);
            this.running = this.context != null && this.context.isRunning();
        }
        catch (InterruptedException e) {
            this.running = false;
            Thread.currentThread().interrupt();
        }
    }

    static SpringApplicationBuilder builder(String type) {
        if (ClassUtils.hasConstructor(SpringApplicationBuilder.class, (Class[])new Class[]{Class[].class})) {
            return (SpringApplicationBuilder)BeanUtils.instantiateClass((Constructor)ClassUtils.getConstructorIfAvailable(SpringApplicationBuilder.class, (Class[])new Class[]{Class[].class}), (Object[])new Object[]{new Class[]{ClassUtils.resolveClassName((String)type, null)}});
        }
        return (SpringApplicationBuilder)BeanUtils.instantiateClass((Constructor)ClassUtils.getConstructorIfAvailable(SpringApplicationBuilder.class, (Class[])new Class[]{Object[].class}), (Object[])new Object[]{new Object[]{type}});
    }

    public void close() {
        if (this.context != null) {
            this.context.close();
        }
        try {
            new JdbcLeakPrevention().clearJdbcDriverRegistrations();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.running = false;
        this.runThread = null;
    }

    public boolean isRunning() {
        return this.running;
    }

    public Throwable getError() {
        return this.error;
    }
}

