/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.thin;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.thin.ThinJarAppWrapper;

class InMemoryAppInstanceStatus
implements AppInstanceStatus {
    private final String id = UUID.randomUUID().toString();
    private final ThinJarAppWrapper wrapper;

    public InMemoryAppInstanceStatus(ThinJarAppWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public String getId() {
        return this.id;
    }

    public DeploymentState getState() {
        LaunchState state = this.wrapper.getState();
        switch (state) {
            case running: {
                return DeploymentState.deployed;
            }
            case failed: {
                return DeploymentState.failed;
            }
            case cancelled: {
                return DeploymentState.undeployed;
            }
        }
        return DeploymentState.unknown;
    }

    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }
}

