/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.yarn;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.yarn.support.console.ContainerClusterReport;

public interface YarnCloudAppService {
    public Collection<CloudAppInfo> getApplications(CloudAppType var1);

    public Collection<CloudAppInstanceInfo> getInstances(CloudAppType var1);

    public void pushApplication(String var1, CloudAppType var2);

    public String submitApplication(String var1, CloudAppType var2);

    public String submitApplication(String var1, CloudAppType var2, List<String> var3);

    public void killApplications(String var1, CloudAppType var2);

    public void killApplication(String var1, CloudAppType var2);

    public void createCluster(String var1, String var2, int var3, String var4, Map<String, String> var5);

    public void startCluster(String var1, String var2);

    public void stopCluster(String var1, String var2);

    public Map<String, ContainerClusterReport.ClustersInfoReportData> getClustersStates(String var1);

    public Collection<String> getClusters(String var1);

    public void destroyCluster(String var1, String var2);

    public void pushArtifact(Resource var1, String var2);

    public static enum CloudAppType {
        STREAM,
        TASK;

    }

    public static class CloudAppInstanceInfo {
        private final String applicationId;
        private final String name;
        private final String state;
        private final String address;

        public CloudAppInstanceInfo(String applicationId, String name, String state, String address) {
            this.applicationId = applicationId;
            this.name = name;
            this.state = state;
            this.address = address;
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public String getName() {
            return this.name;
        }

        public String getState() {
            return this.state;
        }

        public String getAddress() {
            return this.address;
        }

        public String toString() {
            return "CloudAppInstanceInfo [applicationId=" + this.applicationId + ", name=" + this.name + ", state=" + this.state + ", address=" + this.address + "]";
        }
    }

    public static class CloudAppInfo {
        private final String name;

        public CloudAppInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

