/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.MapperFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.function.adapter.aws.AWSCompanionAutoConfiguration;
import org.springframework.cloud.function.adapter.aws.AWSLambdaUtils;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionalSpringApplication;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.json.JacksonMapper;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class FunctionInvoker
implements RequestStreamHandler {
    private static Log logger = LogFactory.getLog(FunctionInvoker.class);
    private JsonMapper jsonMapper;
    private SimpleFunctionRegistry.FunctionInvocationWrapper function;
    private volatile String functionDefinition;
    private boolean started;

    public FunctionInvoker(String functionDefinition) {
        this.functionDefinition = functionDefinition;
        String lateInitialization = System.getenv("FUNCTION_INVOKER_LATE_INITIALIZATION");
        if (!StringUtils.hasText((String)lateInitialization) || !Boolean.parseBoolean(lateInitialization)) {
            this.start();
        } else {
            logger.info((Object)"Spring Application Context will be initialized on first request");
        }
    }

    public FunctionInvoker() {
        this(null);
    }

    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        if (!this.started) {
            this.start();
        }
        Message requestMessage = AWSLambdaUtils.generateMessage(input, this.function.getInputType(), this.function.isSupplier(), this.jsonMapper, context);
        Object response = this.function.apply((Object)requestMessage);
        byte[] responseBytes = AWSLambdaUtils.generateOutputFromObject(requestMessage, response, this.jsonMapper, this.function.getOutputType());
        StreamUtils.copy((byte[])responseBytes, (OutputStream)output);
    }

    private void start() {
        Class startClass = FunctionClassUtils.getStartClass();
        String[] properties = new String[]{"--spring.cloud.function.web.export.enabled=false", "--spring.main.web-application-type=none"};
        ConfigurableApplicationContext context = ApplicationContextInitializer.class.isAssignableFrom(startClass) ? FunctionalSpringApplication.run((Class[])new Class[]{startClass, AWSCompanionAutoConfiguration.class}, (String[])properties) : new SpringApplicationBuilder(new Class[0]).main(startClass).sources(new Class[]{startClass, AWSCompanionAutoConfiguration.class}).run(properties);
        ConfigurableEnvironment environment = context.getEnvironment();
        if (!StringUtils.hasText((String)this.functionDefinition)) {
            this.functionDefinition = environment.getProperty("spring.cloud.function.definition");
        }
        FunctionCatalog functionCatalog = (FunctionCatalog)context.getBean(FunctionCatalog.class);
        this.jsonMapper = (JsonMapper)context.getBean(JsonMapper.class);
        if (this.jsonMapper instanceof JacksonMapper) {
            ((JacksonMapper)this.jsonMapper).configureObjectMapper(objectMapper -> {
                if (!objectMapper.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)) {
                    objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
                }
            });
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Locating function: '" + this.functionDefinition + "'"));
        }
        this.function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(this.functionDefinition, new String[]{"application/json"});
        if (this.function == null) {
            if (logger.isInfoEnabled()) {
                Set names;
                if (!StringUtils.hasText((String)this.functionDefinition)) {
                    logger.info((Object)"Failed to determine default function. Please use 'spring.cloud.function.definition' property or pass function definition as a constructir argument to this FunctionInvoker");
                }
                if ((names = functionCatalog.getNames(null)).size() == 1) {
                    logger.info((Object)"Will default to RoutingFunction, since it is the only function available in FunctionCatalog.Expecting 'spring.cloud.function.definition' or 'spring.cloud.function.routing-expression' as Message headers. If invocation is over API Gateway, Message headers can be provided as HTTP headers.");
                } else {
                    logger.info((Object)("More then one function is available in FunctionCatalog. " + names + " Will default to RoutingFunction, Expecting 'spring.cloud.function.definition' or 'spring.cloud.function.routing-expression' as Message headers. If invocation is over API Gateway, Message headers can be provided as HTTP headers."));
                }
            }
            this.function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup("functionRouter", new String[]{"application/json"});
        }
        if (this.function.isOutputTypePublisher()) {
            this.function.setSkipOutputConversion(true);
        }
        Assert.notNull((Object)this.function, (String)("Failed to lookup function " + this.functionDefinition));
        this.functionDefinition = this.function.getFunctionDefinition();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Located function: '" + this.functionDefinition + "'"));
        }
        this.started = true;
    }
}

