/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.cloudevent;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.cloud.function.cloudevent.CloudEventMessageBuilder;
import org.springframework.cloud.function.context.message.MessageUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

public final class CloudEventMessageUtils {
    private static final ContentTypeResolver contentTypeResolver = new DefaultContentTypeResolver(){

        public MimeType resolve(@Nullable MessageHeaders headers) {
            if (headers.containsKey((Object)"content-type")) {
                return MimeType.valueOf((String)headers.get((Object)"content-type").toString());
            }
            return super.resolve(headers);
        }
    };
    static String _DATA = "data";
    static String _ID = "id";
    static String _SOURCE = "source";
    static String _SPECVERSION = "specversion";
    static String _TYPE = "type";
    static String _DATACONTENTTYPE = "datacontenttype";
    static String _DATASCHEMA = "dataschema";
    static String _SCHEMAURL = "schemaurl";
    static String _SUBJECT = "subject";
    static String _TIME = "time";
    public static String CLOUDEVENT_VALUE = "cloudevent";
    public static String APPLICATION_CLOUDEVENTS_VALUE = "application/cloudevents";
    public static MimeType APPLICATION_CLOUDEVENTS = MimeTypeUtils.parseMimeType((String)APPLICATION_CLOUDEVENTS_VALUE);
    public static String DEFAULT_ATTR_PREFIX = "ce-";
    public static String AMQP_ATTR_PREFIX = "cloudEvents:";
    public static String KAFKA_ATTR_PREFIX = "ce_";
    public static String DATA = DEFAULT_ATTR_PREFIX + _DATA;
    public static String ID = DEFAULT_ATTR_PREFIX + _ID;
    public static String SOURCE = DEFAULT_ATTR_PREFIX + _SOURCE;
    public static String SPECVERSION = DEFAULT_ATTR_PREFIX + _SPECVERSION;
    public static String TYPE = DEFAULT_ATTR_PREFIX + _TYPE;
    public static String DATACONTENTTYPE = DEFAULT_ATTR_PREFIX + _DATACONTENTTYPE;
    public static String DATASCHEMA = DEFAULT_ATTR_PREFIX + _DATASCHEMA;
    public static final String SCHEMAURL = DEFAULT_ATTR_PREFIX + _SCHEMAURL;
    public static String SUBJECT = DEFAULT_ATTR_PREFIX + _SUBJECT;
    public static String TIME = DEFAULT_ATTR_PREFIX + _TIME;

    private CloudEventMessageUtils() {
    }

    public static String getId(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        Object value = message.getHeaders().get((Object)(prefix + "id"));
        if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            value = CloudEventMessageUtils.toString(v);
        }
        return (String)value;
    }

    public static URI getSource(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        return CloudEventMessageUtils.safeGetURI((Map<String, Object>)message.getHeaders(), prefix + _SOURCE);
    }

    public static String getSpecVersion(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        Object value = message.getHeaders().get((Object)(prefix + _SPECVERSION));
        if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            value = CloudEventMessageUtils.toString(v);
        }
        return (String)value;
    }

    public static String getType(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        Object value = message.getHeaders().get((Object)(prefix + _TYPE));
        if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            value = CloudEventMessageUtils.toString(v);
        }
        return (String)value;
    }

    public static String getDataContentType(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        Object value = message.getHeaders().get((Object)(prefix + _DATACONTENTTYPE));
        if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            value = CloudEventMessageUtils.toString(v);
        }
        return (String)value;
    }

    public static URI getDataSchema(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        return CloudEventMessageUtils.safeGetURI((Map<String, Object>)message.getHeaders(), prefix + _DATASCHEMA);
    }

    public static String getSubject(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        Object value = message.getHeaders().get((Object)(prefix + _SUBJECT));
        if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            value = CloudEventMessageUtils.toString(v);
        }
        return (String)value;
    }

    public static OffsetDateTime getTime(Message<?> message) {
        String prefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)message.getHeaders());
        Object time = message.getHeaders().get((Object)(prefix + _TIME));
        return time instanceof String ? OffsetDateTime.parse((String)time) : null;
    }

    public static <T> T getData(Message<?> message) {
        return (T)message.getPayload();
    }

    public static Map<String, Object> getAttributes(Message<?> message) {
        return message.getHeaders().entrySet().stream().filter(e -> CloudEventMessageUtils.isAttribute((String)e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
    }

    static Message<?> toCanonical(Message<?> inputMessage, MessageConverter messageConverter) {
        inputMessage = CloudEventMessageUtils.canonicalizeHeadersWithPossibleCopy(inputMessage);
        HashMap headers = new HashMap(inputMessage.getHeaders());
        boolean isCloudEvent = CloudEventMessageUtils.isCloudEvent(inputMessage);
        if (isCloudEvent && headers.containsKey("content-type")) {
            inputMessage = MessageBuilder.fromMessage(inputMessage).setHeader("contentType", headers.get("content-type")).build();
        }
        MimeType contentType = contentTypeResolver.resolve(inputMessage.getHeaders());
        String inputContentType = (String)inputMessage.getHeaders().get((Object)DATACONTENTTYPE);
        if (!isCloudEvent && contentType != null) {
            if (contentType.getType().equals(APPLICATION_CLOUDEVENTS.getType()) && contentType.getSubtype().startsWith(APPLICATION_CLOUDEVENTS.getSubtype())) {
                String dataContentType = StringUtils.hasText((String)inputContentType) ? inputContentType : "application/json";
                String suffix = contentType.getSubtypeSuffix() == null ? "json" : contentType.getSubtypeSuffix();
                MimeType cloudEventDeserializationContentType = MimeTypeUtils.parseMimeType((String)(contentType.getType() + "/" + suffix));
                Message cloudEventMessage = MessageBuilder.fromMessage((Message)inputMessage).setHeader("contentType", (Object)cloudEventDeserializationContentType).setHeader(DATACONTENTTYPE, (Object)dataContentType).build();
                Map structuredCloudEvent = (Map)messageConverter.fromMessage(cloudEventMessage, Map.class);
                CloudEventMessageUtils.canonicalizeHeaders(structuredCloudEvent, true);
                return CloudEventMessageUtils.buildBinaryMessageFromStructuredMap(structuredCloudEvent, inputMessage.getHeaders());
            }
        } else if (StringUtils.hasText((String)inputContentType)) {
            return MessageBuilder.fromMessage((Message)inputMessage).setHeader("contentType", (Object)inputContentType).build();
        }
        return inputMessage;
    }

    static Message<?> canonicalizeHeadersWithPossibleCopy(Message<?> message) {
        HashMap<String, Object> headers = new HashMap<String, Object>((Map<String, Object>)message.getHeaders());
        boolean headersModified = CloudEventMessageUtils.canonicalizeHeaders(headers, false);
        if (headersModified) {
            message = MessageBuilder.fromMessage(message).removeHeaders(new String[]{"*"}).copyHeaders(headers).build();
        }
        return message;
    }

    private static boolean canonicalizeHeaders(Map<String, Object> headers, boolean structured) {
        String[] keys;
        boolean modified = false;
        for (String key : keys = headers.keySet().toArray(new String[0])) {
            Object value;
            if (key.startsWith(DEFAULT_ATTR_PREFIX)) {
                value = headers.remove(key);
                String newKey = DEFAULT_ATTR_PREFIX + key.substring(DEFAULT_ATTR_PREFIX.length());
                headers.put(newKey, value);
                modified |= !Objects.equals(key, newKey);
                continue;
            }
            if (key.startsWith(KAFKA_ATTR_PREFIX)) {
                value = headers.remove(key);
                key = key.substring(KAFKA_ATTR_PREFIX.length());
                headers.put(DEFAULT_ATTR_PREFIX + key, value);
                modified = true;
                continue;
            }
            if (key.startsWith(AMQP_ATTR_PREFIX)) {
                value = headers.remove(key);
                key = key.substring(AMQP_ATTR_PREFIX.length());
                headers.put(DEFAULT_ATTR_PREFIX + key, value);
                modified = true;
                continue;
            }
            if (!structured) continue;
            value = headers.remove(key);
            headers.put(DEFAULT_ATTR_PREFIX + key, value);
            modified = true;
        }
        return modified;
    }

    static String determinePrefixToUse(Map<String, Object> messageHeaders) {
        return CloudEventMessageUtils.determinePrefixToUse(messageHeaders, false);
    }

    static String determinePrefixToUse(Map<String, Object> messageHeaders, boolean strict) {
        String targetProtocol = (String)messageHeaders.get(MessageUtils.TARGET_PROTOCOL);
        String prefix = CloudEventMessageUtils.determinePrefixToUse(targetProtocol);
        if (StringUtils.hasText((String)prefix) && (strict || StringUtils.hasText((String)((String)messageHeaders.get(prefix + _SPECVERSION))))) {
            return prefix;
        }
        for (String key : messageHeaders.keySet()) {
            if (key.startsWith(DEFAULT_ATTR_PREFIX)) {
                return DEFAULT_ATTR_PREFIX;
            }
            if (key.startsWith(KAFKA_ATTR_PREFIX)) {
                return KAFKA_ATTR_PREFIX;
            }
            if (!key.startsWith(AMQP_ATTR_PREFIX)) continue;
            return AMQP_ATTR_PREFIX;
        }
        return DEFAULT_ATTR_PREFIX;
    }

    static String determinePrefixToUse(String targetProtocol) {
        if (StringUtils.hasText((String)targetProtocol)) {
            if (Protocols.KAFKA.equals(targetProtocol)) {
                return KAFKA_ATTR_PREFIX;
            }
            if (Protocols.AMQP.equals(targetProtocol)) {
                return AMQP_ATTR_PREFIX;
            }
            if (Protocols.HTTP.equals(targetProtocol)) {
                return DEFAULT_ATTR_PREFIX;
            }
        }
        return "";
    }

    public static boolean isCloudEvent(Message<?> message) {
        MessageUtils.MessageStructureWithCaseInsensitiveHeaderKeys _message = MessageUtils.toCaseInsensitiveHeadersStructure(message);
        return _message.getHeaders().containsKey(SPECVERSION) && _message.getHeaders().containsKey(TYPE) && _message.getHeaders().containsKey(SOURCE) || _message.getHeaders().containsKey(_SPECVERSION) && _message.getHeaders().containsKey(_TYPE) && _message.getHeaders().containsKey(_SOURCE) || _message.getHeaders().containsKey(AMQP_ATTR_PREFIX + _SPECVERSION) && _message.getHeaders().containsKey(AMQP_ATTR_PREFIX + _TYPE) && _message.getHeaders().containsKey(AMQP_ATTR_PREFIX + _SOURCE) || _message.getHeaders().containsKey(KAFKA_ATTR_PREFIX + _SPECVERSION) && _message.getHeaders().containsKey(KAFKA_ATTR_PREFIX + _TYPE) && _message.getHeaders().containsKey(KAFKA_ATTR_PREFIX + _SOURCE);
    }

    private static boolean isAttribute(String key) {
        return key.startsWith(DEFAULT_ATTR_PREFIX) || key.startsWith(AMQP_ATTR_PREFIX) || key.startsWith(KAFKA_ATTR_PREFIX);
    }

    private static Message<?> buildBinaryMessageFromStructuredMap(Map<String, Object> structuredCloudEvent, MessageHeaders originalHeaders) {
        Map payload = structuredCloudEvent.remove(DATA);
        if (payload == null) {
            payload = Collections.emptyMap();
        }
        CloudEventMessageBuilder messageBuilder = CloudEventMessageBuilder.withData(payload).copyHeaders(structuredCloudEvent);
        for (String key : originalHeaders.keySet()) {
            if ("id".equals(key)) continue;
            messageBuilder.setHeader(key, originalHeaders.get((Object)key));
        }
        return messageBuilder.build();
    }

    private static URI safeGetURI(Map<String, Object> map, String key) {
        Object uri = map.get(key);
        if (uri != null) {
            if (uri instanceof String) {
                uri = URI.create((String)uri);
            } else if (uri instanceof byte[]) {
                byte[] u = (byte[])uri;
                uri = URI.create(CloudEventMessageUtils.toString(u));
            }
        }
        return (URI)uri;
    }

    private static String toString(byte[] value) {
        return new String(value, StandardCharsets.UTF_8);
    }

    public static class Protocols {
        static String AMQP = "amqp";
        static String AVRO = "avro";
        static String HTTP = "http";
        static String JSON = "json";
        static String KAFKA = "kafka";
    }
}

