/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.core;

import java.util.function.Supplier;
import org.springframework.cloud.function.core.Isolated;
import org.springframework.util.ClassUtils;

public class IsolatedSupplier<T>
implements Supplier<T>,
Isolated {
    private final Supplier<T> supplier;
    private final ClassLoader classLoader;

    public IsolatedSupplier(Supplier<T> supplier) {
        this.supplier = supplier;
        this.classLoader = supplier.getClass().getClassLoader();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public T get() {
        ClassLoader context = ClassUtils.overrideThreadContextClassLoader((ClassLoader)this.classLoader);
        try {
            T t = this.supplier.get();
            return t;
        }
        finally {
            ClassUtils.overrideThreadContextClassLoader((ClassLoader)context);
        }
    }
}

