/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.grpc;

import io.grpc.BindableService;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.grpc.FunctionGrpcProperties;
import org.springframework.cloud.function.grpc.GrpcMessageConverter;
import org.springframework.cloud.function.grpc.GrpcServer;
import org.springframework.cloud.function.grpc.GrpcServerMessageHandler;
import org.springframework.cloud.function.grpc.GrpcSpringMessageConverter;
import org.springframework.cloud.function.grpc.MessageHandlingHelper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={FunctionGrpcProperties.class})
@ConditionalOnProperty(name={"spring.cloud.function.grpc.server"}, havingValue="true", matchIfMissing=true)
class GrpcAutoConfiguration {
    GrpcAutoConfiguration() {
    }

    @Bean
    public GrpcServer grpcServer(FunctionGrpcProperties grpcProperties, BindableService[] grpcMessagingServices) {
        Assert.notEmpty((Object[])grpcMessagingServices, (String)"'grpcMessagingServices' must not be null or empty");
        if (StringUtils.hasText((String)grpcProperties.getServiceClassName())) {
            for (BindableService bindableService : grpcMessagingServices) {
                if (!bindableService.getClass().getName().equals(grpcProperties.getServiceClassName())) continue;
                return new GrpcServer(grpcProperties, new BindableService[]{bindableService});
            }
        }
        return new GrpcServer(grpcProperties, grpcMessagingServices);
    }

    @Bean
    public BindableService grpcSpringMessageHandler(MessageHandlingHelper helper) {
        return new GrpcServerMessageHandler(helper);
    }

    @Bean
    public MessageHandlingHelper grpcMessageHandlingHelper(List<GrpcMessageConverter<?>> grpcConverters, FunctionProperties funcProperties, FunctionCatalog functionCatalog) {
        return new MessageHandlingHelper(grpcConverters, functionCatalog, funcProperties);
    }

    @Bean
    public GrpcSpringMessageConverter grpcSpringMessageConverter() {
        return new GrpcSpringMessageConverter();
    }
}

