/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.protobuf.services.ProtoReflectionService;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.grpc.FunctionGrpcProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

class GrpcServer
implements SmartLifecycle,
EnvironmentAware {
    private Log logger = LogFactory.getLog(GrpcServer.class);
    private final FunctionGrpcProperties grpcProperties;
    private final BindableService[] grpcMessageServices;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private Server server;
    private Environment environment;

    GrpcServer(FunctionGrpcProperties grpcProperties, BindableService[] grpcMessageServices) {
        this.grpcProperties = grpcProperties;
        this.grpcMessageServices = grpcMessageServices;
    }

    public void start() {
        this.executor.execute(() -> {
            try {
                ServerBuilder serverBuilder = ServerBuilder.forPort((int)this.grpcProperties.getPort());
                for (int i = 0; i < this.grpcMessageServices.length; ++i) {
                    BindableService bindableService = this.grpcMessageServices[i];
                    serverBuilder.addService(bindableService);
                }
                if (ClassUtils.isPresent((String)"io.grpc.protobuf.services.ProtoReflectionService", null)) {
                    serverBuilder.addService(ProtoReflectionService.newInstance());
                }
                this.server = serverBuilder.build();
                this.logger.info((Object)"Starting gRPC server");
                this.server.start();
                this.logger.info((Object)("gRPC server is listening on port " + this.server.getPort()));
                if (this.environment instanceof ConfigurableEnvironment) {
                    ((ConfigurableEnvironment)this.environment).getPropertySources().addFirst((PropertySource)new MapPropertySource("grpcServerProps", Collections.singletonMap("local.grpc.server.port", this.server.getPort())));
                }
            }
            catch (Exception e) {
                this.stop();
                throw new IllegalStateException(e);
            }
        });
    }

    public void stop() {
        this.logger.info((Object)"Shutting down gRPC server");
        this.server.shutdownNow();
        this.executor.shutdownNow();
    }

    public boolean isRunning() {
        return this.server != null && !this.server.isShutdown();
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

