/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.rsocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.rsocket.FunctionRSocketUtils;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDecoder;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

class MessageAwareJsonDecoder
extends AbstractDecoder<Object> {
    private final JsonMapper jsonMapper;

    MessageAwareJsonDecoder(JsonMapper jsonMapper) {
        super(new MimeType[]{MimeTypeUtils.APPLICATION_JSON});
        this.jsonMapper = jsonMapper;
    }

    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return mimeType != null && mimeType.isCompatibleWith(MimeTypeUtils.APPLICATION_JSON);
    }

    public Object decode(DataBuffer dataBuffer, ResolvableType targetType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) throws DecodingException {
        ResolvableType type = ResolvableType.forClassWithGenerics(Map.class, (Class[])new Class[]{String.class, Object.class});
        Map messageMap = (Map)this.doDecode(dataBuffer, type, mimeType, hints);
        if (messageMap.containsKey(FunctionRSocketUtils.PAYLOAD)) {
            Type requestedType = FunctionTypeUtils.getGenericType((Type)targetType.getType());
            Object payload = this.jsonMapper.fromJson(messageMap.get(FunctionRSocketUtils.PAYLOAD), requestedType);
            if (FunctionTypeUtils.isMessage((Type)targetType.getType())) {
                return MessageBuilder.withPayload((Object)payload).copyHeaders((Map)messageMap.get(FunctionRSocketUtils.HEADERS)).build();
            }
            return payload;
        }
        return messageMap;
    }

    private Object doDecode(DataBuffer dataBuffer, ResolvableType targetType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) throws DecodingException {
        try {
            byte[] data = this.toByteArray(dataBuffer.asInputStream());
            Object object = this.jsonMapper.fromJson((Object)data, targetType.getType());
            return object;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            DataBufferUtils.release((DataBuffer)dataBuffer);
        }
    }

    private byte[] toByteArray(InputStream input) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            this.copyLarge(input, output, new byte[2048]);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    private long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public Flux<Object> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, MimeType mimeType, Map<String, Object> hints) {
        return Flux.from(inputStream).map(buffer -> this.decode((DataBuffer)buffer, elementType, mimeType, hints));
    }
}

