/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.task;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.task.TaskConfigurationProperties;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Mono;

@Configuration
@EnableTask
@EnableConfigurationProperties(value={TaskConfigurationProperties.class})
@ConditionalOnClass(value={EnableTask.class})
public class TaskConfiguration {
    @Autowired
    private TaskConfigurationProperties properties;

    @Bean
    public CommandLineRunner commandLineRunner(FunctionCatalog registry) {
        final Supplier supplier = (Supplier)registry.lookup(Supplier.class, this.properties.getSupplier());
        final Function function = (Function)registry.lookup(Function.class, this.properties.getFunction());
        final Consumer<Publisher<Object>> consumer = this.consumer(registry);
        CommandLineRunner runner = new CommandLineRunner(){

            public void run(String ... args) throws Exception {
                consumer.accept(function.apply(supplier.get()));
            }
        };
        return runner;
    }

    private Consumer<Publisher<Object>> consumer(FunctionCatalog registry) {
        Consumer consumer = (Consumer)registry.lookup(Consumer.class, this.properties.getConsumer());
        if (consumer != null) {
            return consumer;
        }
        Function function = (Function)registry.lookup(Function.class, this.properties.getConsumer());
        return flux -> Mono.from((Publisher)((Publisher)function.apply(flux))).subscribe();
    }
}

