/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.source;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.function.web.source.RequestBuilder;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;

class SimpleRequestBuilder
implements RequestBuilder {
    private String baseUrl = "http://${destination}";
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private Environment environment;

    SimpleRequestBuilder(Environment environment) {
        this.environment = environment;
    }

    @Override
    public HttpHeaders headers(String destination, Object value) {
        HttpHeaders result = new HttpHeaders();
        for (String key : this.headers.keySet()) {
            String header = this.headers.get(key);
            header = header.replace("${destination}", destination);
            header = this.environment.resolvePlaceholders(header);
            result.add(key, header);
        }
        return result;
    }

    @Override
    public URI uri(String destination) {
        try {
            return new URI(this.environment.resolvePlaceholders(this.baseUrl.replace("${destination}", destination)));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot create URI", e);
        }
    }

    public void setTemplateUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }
}

