/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.messaging.MessageHeaders;

public final class HeaderUtils {
    private static HttpHeaders IGNORED = new HttpHeaders();
    private static HttpHeaders REQUEST_ONLY = new HttpHeaders();

    private HeaderUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static HttpHeaders fromMessage(MessageHeaders headers) {
        HttpHeaders result = new HttpHeaders();
        for (String name : headers.keySet()) {
            Object value = headers.get((Object)name);
            if (IGNORED.containsKey((Object)(name = name.toLowerCase()))) continue;
            Collection<?> values = HeaderUtils.multi(value);
            for (Object object : values) {
                result.set(name, object.toString());
            }
        }
        return result;
    }

    public static HttpHeaders sanitize(HttpHeaders request) {
        HttpHeaders result = new HttpHeaders();
        for (String name : request.keySet()) {
            List value = request.get((Object)name);
            if (IGNORED.containsKey((Object)(name = name.toLowerCase())) || REQUEST_ONLY.containsKey((Object)name)) continue;
            result.put(name, value);
        }
        return result;
    }

    public static MessageHeaders fromHttp(HttpHeaders headers) {
        LinkedHashMap map = new LinkedHashMap();
        for (String name : headers.keySet()) {
            Collection<?> value;
            Collection<?> values = HeaderUtils.multi(headers.get((Object)name));
            name = name.toLowerCase();
            Collection<?> collection = values == null ? null : (value = values.size() == 1 ? values.iterator().next() : values);
            if (name.toLowerCase().equals("Content-Type".toLowerCase())) {
                name = "contentType";
            }
            map.put(name, value);
        }
        return new MessageHeaders(map);
    }

    private static Collection<?> multi(Object value) {
        return value instanceof Collection ? (List<Object>)value : Arrays.asList(value);
    }

    static {
        IGNORED.add("id", "");
        IGNORED.add("Content-Length", "0");
        REQUEST_ONLY.add("Accept", "");
        REQUEST_ONLY.add("Content-Length", "");
        REQUEST_ONLY.add("Content-Type", "");
        REQUEST_ONLY.add("Host", "");
    }
}

