/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.function;

import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.web.RequestProcessor;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.cloud.function.web.util.FunctionWebRequestProcessingHelper;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class FunctionEndpointFactory {
    private static Log logger = LogFactory.getLog(FunctionEndpointFactory.class);
    private final FunctionCatalog functionCatalog;
    private final String handler;
    private final RequestProcessor processor;
    private final FunctionProperties functionProperties;

    FunctionEndpointFactory(FunctionProperties functionProperties, FunctionCatalog functionCatalog, RequestProcessor processor, Environment environment) {
        String handler = environment.resolvePlaceholders("${function.handler}");
        if (handler.startsWith("$")) {
            handler = null;
        }
        this.processor = processor;
        this.functionCatalog = functionCatalog;
        this.handler = handler;
        this.functionProperties = functionProperties;
    }

    private SimpleFunctionRegistry.FunctionInvocationWrapper extract(ServerRequest request) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function;
        if (this.handler != null) {
            logger.info((Object)("Configured function: " + this.handler));
            Set names = this.functionCatalog.getNames(Function.class);
            Assert.isTrue((boolean)names.contains(this.handler), (String)("Cannot locate function: " + this.handler));
            function = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.functionCatalog.lookup(Function.class, this.handler);
        } else {
            String[] accept = FunctionWebRequestProcessingHelper.acceptContentTypes(request.headers().accept());
            function = FunctionWebRequestProcessingHelper.findFunction(this.functionProperties, request.method(), this.functionCatalog, request.attributes(), request.path(), accept);
        }
        return function;
    }

    public <T> RouterFunction<?> functionEndpoints() {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.POST((String)"/**"), request -> {
            SimpleFunctionRegistry.FunctionInvocationWrapper funcWrapper = this.extract(request);
            Class outputType = funcWrapper == null ? Object.class : FunctionTypeUtils.getRawType((Type)FunctionTypeUtils.getGenericType((Type)funcWrapper.getOutputType()));
            RequestProcessor.FunctionWrapper wrapper = RequestProcessor.wrapper(funcWrapper);
            Mono stream = request.bodyToMono(String.class).flatMap(content -> this.processor.post(wrapper, (String)content, false));
            return stream.flatMap(entity -> {
                ServerResponse.BodyBuilder builder = (ServerResponse.BodyBuilder)ServerResponse.status((HttpStatus)entity.getStatusCode()).headers(headers -> headers.addAll((MultiValueMap)entity.getHeaders()));
                if (outputType == null) {
                    return builder.build();
                }
                return builder.body((Object)(entity != null && entity.hasBody() ? Mono.just((Object)entity.getBody()) : Mono.empty()), outputType);
            });
        }).andRoute(RequestPredicates.GET((String)"/**"), request -> {
            SimpleFunctionRegistry.FunctionInvocationWrapper funcWrapper = this.extract(request);
            Class outputType = FunctionTypeUtils.getRawType((Type)FunctionTypeUtils.getGenericType((Type)funcWrapper.getOutputType()));
            if (funcWrapper.isSupplier()) {
                Object result = FunctionWebRequestProcessingHelper.invokeFunction(funcWrapper, null, funcWrapper.isInputTypeMessage());
                if (!(result instanceof Publisher)) {
                    result = Mono.just((Object)result);
                }
                return ServerResponse.ok().body(result, outputType);
            }
            RequestProcessor.FunctionWrapper wrapper = RequestProcessor.wrapper(funcWrapper);
            wrapper.headers(request.headers().asHttpHeaders());
            String argument = (String)request.attribute(WebRequestConstants.ARGUMENT).get();
            wrapper.argument((Publisher<String>)Flux.just((Object)argument));
            Object result = FunctionWebRequestProcessingHelper.invokeFunction(funcWrapper, wrapper.argument(), funcWrapper.isInputTypeMessage());
            return ServerResponse.ok().body(result, outputType);
        });
    }
}

