/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.cloud.function.web.util.FunctionWrapper;
import org.springframework.cloud.function.web.util.HeaderUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FunctionWebRequestProcessingHelper {
    private static Log logger = LogFactory.getLog(FunctionWebRequestProcessingHelper.class);

    private FunctionWebRequestProcessingHelper() {
    }

    public static SimpleFunctionRegistry.FunctionInvocationWrapper findFunction(FunctionProperties functionProperties, HttpMethod method, FunctionCatalog functionCatalog, Map<String, Object> attributes, String path, String[] acceptContentTypes) {
        if (method.equals((Object)HttpMethod.GET) || method.equals((Object)HttpMethod.POST)) {
            return FunctionWebRequestProcessingHelper.doFindFunction(functionProperties.getDefinition(), method, functionCatalog, attributes, path, acceptContentTypes);
        }
        throw new IllegalStateException("HTTP method '" + method + "' is not supported;");
    }

    public static String[] acceptContentTypes(List<MediaType> acceptHeaders) {
        Object[] acceptContentTypes = new String[]{};
        acceptContentTypes = !CollectionUtils.isEmpty(acceptHeaders) ? (String[])acceptHeaders.stream().map(mediaType -> mediaType.toString()).toArray(String[]::new) : new String[]{MediaType.APPLICATION_JSON.toString()};
        acceptContentTypes = new String[]{StringUtils.arrayToCommaDelimitedString((Object[])acceptContentTypes)};
        return new String[0];
    }

    public static Object invokeFunction(SimpleFunctionRegistry.FunctionInvocationWrapper function, Object input, boolean isMessage) {
        Object result = function.apply(input);
        return FunctionWebRequestProcessingHelper.postProcessResult(result, isMessage);
    }

    public static Publisher<?> processRequest(FunctionWrapper wrapper, Object argument, boolean eventStream) {
        Publisher pResult;
        SimpleFunctionRegistry.FunctionInvocationWrapper function = wrapper.getFunction();
        HttpHeaders headers = wrapper.getHeaders();
        Message inputMessage = null;
        if (argument != null) {
            MessageBuilder builder = MessageBuilder.withPayload((Object)argument);
            if (!CollectionUtils.isEmpty(wrapper.getParams())) {
                builder = builder.setHeader("http_request_param", (Object)wrapper.getParams().toSingleValueMap());
            }
            inputMessage = builder.copyHeaders(headers.toSingleValueMap()).build();
        }
        if (function.isRoutingFunction()) {
            function.setSkipOutputConversion(true);
        }
        String input = argument == null ? "" : (argument instanceof Publisher ? Flux.from((Publisher)((Publisher)argument)) : inputMessage);
        Object result = function.apply((Object)input);
        if (function.isConsumer()) {
            if (result instanceof Publisher) {
                Mono.from((Publisher)((Publisher)result)).subscribe();
            }
            return Mono.just((Object)((ResponseEntity.BodyBuilder)ResponseEntity.accepted().headers(HeaderUtils.sanitize(headers))).build());
        }
        ResponseEntity.BodyBuilder responseOkBuilder = (ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtils.sanitize(headers));
        if (result instanceof Publisher) {
            pResult = (Publisher)result;
            if (eventStream) {
                return Flux.from((Publisher)pResult);
            }
            if (pResult instanceof Flux) {
                pResult = ((Flux)pResult).onErrorContinue((e, v) -> logger.error((Object)("Failed to process value: " + v), (Throwable)e)).collectList();
            }
            pResult = Mono.from((Publisher)pResult);
        } else {
            pResult = Mono.just((Object)result);
        }
        return Mono.from((Publisher)pResult).map(v -> {
            if (v instanceof Iterable) {
                List aggregatedResult = ((Collection)v).stream().map(m -> m instanceof Message ? FunctionWebRequestProcessingHelper.processMessage(responseOkBuilder, (Message)m) : m).collect(Collectors.toList());
                return ((ResponseEntity.BodyBuilder)responseOkBuilder.header("content-type", new String[]{"application/json"})).body(aggregatedResult);
            }
            if (v instanceof Message) {
                return responseOkBuilder.body(FunctionWebRequestProcessingHelper.processMessage(responseOkBuilder, (Message)v));
            }
            return responseOkBuilder.body(v);
        });
    }

    private static Object processMessage(ResponseEntity.BodyBuilder responseOkBuilder, Message<?> message) {
        responseOkBuilder.headers(HeaderUtils.fromMessage(message.getHeaders()));
        return message.getPayload();
    }

    private static SimpleFunctionRegistry.FunctionInvocationWrapper doFindFunction(String functionDefinition, HttpMethod method, FunctionCatalog functionCatalog, Map<String, Object> attributes, String path, String[] acceptContentTypes) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function;
        SimpleFunctionRegistry.FunctionInvocationWrapper function2;
        String string = path = path.startsWith("/") ? path.substring(1) : path;
        if (method.equals((Object)HttpMethod.GET) && (function2 = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(path, acceptContentTypes)) != null && function2.isSupplier()) {
            attributes.put(WebRequestConstants.SUPPLIER, function2);
            return function2;
        }
        StringBuilder builder = new StringBuilder();
        String name = path;
        String value = null;
        for (String element : path.split("/")) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(element);
            name = builder.toString();
            value = path.length() > name.length() ? path.substring(name.length() + 1) : null;
            SimpleFunctionRegistry.FunctionInvocationWrapper function3 = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(name, acceptContentTypes);
            if (function3 == null) continue;
            return FunctionWebRequestProcessingHelper.postProcessFunction(function3, value, attributes);
        }
        if (StringUtils.hasText((String)functionDefinition) && (function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(functionDefinition, acceptContentTypes)) != null) {
            return FunctionWebRequestProcessingHelper.postProcessFunction(function, value, attributes);
        }
        return null;
    }

    private static SimpleFunctionRegistry.FunctionInvocationWrapper postProcessFunction(SimpleFunctionRegistry.FunctionInvocationWrapper function, String argument, Map<String, Object> attributes) {
        attributes.put(WebRequestConstants.FUNCTION, function);
        if (argument != null) {
            attributes.put(WebRequestConstants.ARGUMENT, argument);
        }
        return function;
    }

    private static Object postProcessResult(Object result, boolean isMessage) {
        if (result instanceof Flux) {
            result = ((Flux)result).map(v -> FunctionWebRequestProcessingHelper.postProcessResult(v, isMessage));
        } else if (result instanceof Mono) {
            result = ((Mono)result).map(v -> FunctionWebRequestProcessingHelper.postProcessResult(v, isMessage));
        } else if (result instanceof Message && ((Message)result).getPayload() instanceof byte[]) {
            String str = new String((byte[])((Message)result).getPayload());
            result = MessageBuilder.withPayload((Object)str).copyHeaders((Map)((Message)result).getHeaders()).build();
        }
        if (result instanceof byte[]) {
            result = new String((byte[])result);
        }
        return result;
    }
}

