/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.cloud.function.web.flux.FunctionController;
import org.springframework.cloud.function.web.util.FunctionWebRequestProcessingHelper;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Configuration
@ConditionalOnClass(value={RequestMappingHandlerMapping.class})
public class FunctionHandlerMapping
extends RequestMappingHandlerMapping
implements InitializingBean {
    private final FunctionCatalog functions;
    private final FunctionController controller;
    private final FunctionProperties functionProperties;
    @Value(value="${spring.cloud.function.web.path:}")
    private String prefix = "";

    @Autowired
    public FunctionHandlerMapping(FunctionCatalog catalog, FunctionController controller, FunctionProperties functionProperties) {
        this.functions = catalog;
        this.logger.info((Object)("FunctionCatalog: " + catalog));
        this.setOrder(super.getOrder() - 5);
        this.controller = controller;
        this.functionProperties = functionProperties;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.detectHandlerMethods(this.controller);
        while (this.prefix.endsWith("/")) {
            this.prefix = this.prefix.substring(0, this.prefix.length() - 1);
        }
    }

    public Mono<HandlerMethod> getHandlerInternal(ServerWebExchange request) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function;
        String path = request.getRequest().getPath().pathWithinApplication().value();
        if (StringUtils.hasText((String)this.prefix) && !path.startsWith(this.prefix)) {
            return Mono.empty();
        }
        Mono handler = super.getHandlerInternal(request);
        if (path == null) {
            return handler;
        }
        if (path.startsWith(this.prefix)) {
            path = path.substring(this.prefix.length());
        }
        if ((function = FunctionWebRequestProcessingHelper.findFunction(this.functionProperties, request.getRequest().getMethod(), this.functions, request.getAttributes(), path)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found function for POST: " + path));
            }
            request.getAttributes().put(WebRequestConstants.HANDLER, function);
        }
        SimpleFunctionRegistry.FunctionInvocationWrapper actual = function;
        return handler.filter(method -> actual != null);
    }

    protected void initHandlerMethods() {
    }
}

