/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GatewayMetricsFilter
implements GlobalFilter,
Ordered {
    private MeterRegistry meterRegistry;

    public GatewayMetricsFilter(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public int getOrder() {
        return 0;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        return chain.filter(exchange).doOnSuccessOrError((aVoid, ex) -> this.endTimerRespectingCommit(exchange, sample));
    }

    private void endTimerRespectingCommit(ServerWebExchange exchange, Timer.Sample sample) {
        ServerHttpResponse response = exchange.getResponse();
        if (response.isCommitted()) {
            this.endTimerInner(exchange, sample);
        } else {
            response.beforeCommit(() -> {
                this.endTimerInner(exchange, sample);
                return Mono.empty();
            });
        }
    }

    private void endTimerInner(ServerWebExchange exchange, Timer.Sample sample) {
        String outcome = "CUSTOM";
        String status = "CUSTOM";
        HttpStatus statusCode = exchange.getResponse().getStatusCode();
        if (statusCode != null) {
            outcome = statusCode.series().name();
            status = statusCode.name();
        } else if (exchange.getResponse() instanceof AbstractServerHttpResponse) {
            Integer statusInt = ((AbstractServerHttpResponse)exchange.getResponse()).getStatusCodeValue();
            status = statusInt != null ? String.valueOf(statusInt) : "NA";
        }
        Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        Tags tags = Tags.of((String[])new String[]{"outcome", outcome, "status", status, "routeId", route.getId(), "routeUri", route.getUri().toString()});
        sample.stop(this.meterRegistry.timer("gateway.requests", (Iterable)tags));
    }
}

